/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jackson.databind.util;

import github.scarsz.discordsrv.dependencies.jackson.databind.AnnotationIntrospector;
import github.scarsz.discordsrv.dependencies.jackson.databind.BeanDescription;
import github.scarsz.discordsrv.dependencies.jackson.databind.JavaType;
import github.scarsz.discordsrv.dependencies.jackson.databind.PropertyName;
import github.scarsz.discordsrv.dependencies.jackson.databind.cfg.MapperConfig;
import github.scarsz.discordsrv.dependencies.jackson.databind.introspect.AnnotatedClass;
import github.scarsz.discordsrv.dependencies.jackson.databind.type.ClassKey;
import github.scarsz.discordsrv.dependencies.jackson.databind.util.LRUMap;
import java.io.Serializable;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LRUMap<ClassKey, PropertyName> _rootNames = new LRUMap(20, 200);

    public PropertyName findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    public PropertyName findRootName(Class<?> rootType, MapperConfig<?> config) {
        AnnotatedClass ac;
        ClassKey key = new ClassKey(rootType);
        PropertyName name = this._rootNames.get(key);
        if (name != null) {
            return name;
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        name = intr.findRootName(ac = beanDesc.getClassInfo());
        if (name == null || !name.hasSimpleName()) {
            name = PropertyName.construct(rootType.getSimpleName());
        }
        this._rootNames.put(key, name);
        return name;
    }

    protected Object readResolve() {
        return new RootNameLookup();
    }
}

