/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.entities;

import github.scarsz.discordsrv.dependencies.jda.annotations.DeprecatedSince;
import github.scarsz.discordsrv.dependencies.jda.annotations.ReplaceWith;
import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.IMentionable;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.managers.EmoteManager;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.AuditableRestAction;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.PermissionUtil;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Emote
extends IMentionable {
    public static final String ICON_URL = "https://cdn.discordapp.com/emojis/%s.%s";

    @Nullable
    public Guild getGuild();

    @Nonnull
    public List<Role> getRoles();

    @Deprecated
    @DeprecatedSince(value="3.8.0")
    @ReplaceWith(value="canProvideRoles()")
    default public boolean hasRoles() {
        return this.canProvideRoles();
    }

    public boolean canProvideRoles();

    @Nonnull
    public String getName();

    public boolean isManaged();

    public boolean isAvailable();

    @Nonnull
    public JDA getJDA();

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> delete();

    @Nonnull
    public EmoteManager getManager();

    public boolean isAnimated();

    @Nonnull
    default public String getImageUrl() {
        return String.format(ICON_URL, this.getId(), this.isAnimated() ? "gif" : "png");
    }

    @Override
    @Nonnull
    default public String getAsMention() {
        return (this.isAnimated() ? "<a:" : "<:") + this.getName() + ":" + this.getId() + ">";
    }

    default public boolean canInteract(Member issuer) {
        return PermissionUtil.canInteract(issuer, this);
    }

    default public boolean canInteract(User issuer, MessageChannel channel) {
        return PermissionUtil.canInteract(issuer, this, channel);
    }

    default public boolean canInteract(User issuer, MessageChannel channel, boolean botOverride) {
        return PermissionUtil.canInteract(issuer, this, channel, botOverride);
    }
}

