/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.entities;

import github.scarsz.discordsrv.dependencies.jda.api.entities.AbstractChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Category;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.IMentionable;
import github.scarsz.discordsrv.dependencies.jda.api.entities.IPermissionHolder;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Invite;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.PermissionOverride;
import github.scarsz.discordsrv.dependencies.jda.api.managers.ChannelManager;
import github.scarsz.discordsrv.dependencies.jda.api.requests.RestAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.AuditableRestAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.ChannelAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.InviteAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.PermissionOverrideAction;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface GuildChannel
extends AbstractChannel,
IMentionable,
Comparable<GuildChannel> {
    @Nonnull
    public Guild getGuild();

    @Nullable
    public Category getParent();

    @Nonnull
    public List<Member> getMembers();

    public int getPosition();

    public int getPositionRaw();

    @Nullable
    public PermissionOverride getPermissionOverride(@Nonnull IPermissionHolder var1);

    @Nonnull
    public List<PermissionOverride> getPermissionOverrides();

    @Nonnull
    public List<PermissionOverride> getMemberPermissionOverrides();

    @Nonnull
    public List<PermissionOverride> getRolePermissionOverrides();

    public boolean isSynced();

    @Nonnull
    @CheckReturnValue
    public ChannelAction<? extends GuildChannel> createCopy(@Nonnull Guild var1);

    @Nonnull
    @CheckReturnValue
    default public ChannelAction<? extends GuildChannel> createCopy() {
        return this.createCopy(this.getGuild());
    }

    @Nonnull
    public ChannelManager getManager();

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> delete();

    @Nonnull
    @CheckReturnValue
    public PermissionOverrideAction createPermissionOverride(@Nonnull IPermissionHolder var1);

    @Nonnull
    @CheckReturnValue
    public PermissionOverrideAction putPermissionOverride(@Nonnull IPermissionHolder var1);

    @Nonnull
    @CheckReturnValue
    default public PermissionOverrideAction upsertPermissionOverride(@Nonnull IPermissionHolder permissionHolder) {
        PermissionOverride override = this.getPermissionOverride(permissionHolder);
        if (override != null) {
            return override.getManager();
        }
        return this.putPermissionOverride(permissionHolder);
    }

    @Nonnull
    @CheckReturnValue
    public InviteAction createInvite();

    @Nonnull
    @CheckReturnValue
    public RestAction<List<Invite>> retrieveInvites();
}

