/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.entities;

import github.scarsz.discordsrv.dependencies.jda.annotations.DeprecatedSince;
import github.scarsz.discordsrv.dependencies.jda.annotations.ForRemoval;
import github.scarsz.discordsrv.dependencies.jda.annotations.ReplaceWith;
import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.ChannelType;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.ISnowflake;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.requests.RestAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.AuditableRestAction;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.InviteImpl;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Invite {
    @Nonnull
    public static RestAction<Invite> resolve(@Nonnull JDA api, @Nonnull String code) {
        return Invite.resolve(api, code, false);
    }

    @Nonnull
    public static RestAction<Invite> resolve(@Nonnull JDA api, @Nonnull String code, boolean withCounts) {
        return InviteImpl.resolve(api, code, withCounts);
    }

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> delete();

    @Nonnull
    @CheckReturnValue
    public RestAction<Invite> expand();

    @Nonnull
    public InviteType getType();

    @Nonnull
    public TargetType getTargetType();

    @Nullable
    public Channel getChannel();

    @Nullable
    public Group getGroup();

    @Nullable
    public InviteTarget getTarget();

    @Nonnull
    public String getCode();

    @Nonnull
    default public String getUrl() {
        return "https://discord.gg/" + this.getCode();
    }

    @Nonnull
    @Deprecated
    @ForRemoval(deadline="5.0.0")
    @DeprecatedSince(value="4.0.0")
    @ReplaceWith(value="getTimeCreated()")
    public OffsetDateTime getCreationTime();

    @Nullable
    public Guild getGuild();

    @Nullable
    public User getInviter();

    @Nonnull
    public JDA getJDA();

    public int getMaxAge();

    public int getMaxUses();

    @Nonnull
    public OffsetDateTime getTimeCreated();

    public int getUses();

    public boolean isExpanded();

    public boolean isTemporary();

    public static enum TargetType {
        NONE(0),
        STREAM(1),
        EMBEDDED_APPLICATION(2),
        UNKNOWN(-1);

        private final int id;

        private TargetType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        @Nonnull
        public static TargetType fromId(int id) {
            for (TargetType type : TargetType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return UNKNOWN;
        }
    }

    public static enum InviteType {
        GUILD,
        GROUP,
        UNKNOWN;

    }

    public static interface EmbeddedApplication
    extends ISnowflake {
        @Nonnull
        public String getName();

        @Nonnull
        public String getDescription();

        @Nullable
        public String getSummary();

        @Nullable
        public String getIconId();

        @Nullable
        public String getIconUrl();

        public int getMaxParticipants();
    }

    public static interface InviteTarget {
        @Nonnull
        public TargetType getType();

        @Nonnull
        public String getId();

        public long getIdLong();

        @Nullable
        public User getUser();

        @Nullable
        public EmbeddedApplication getApplication();
    }

    public static interface Group
    extends ISnowflake {
        @Nullable
        public String getIconId();

        @Nullable
        public String getIconUrl();

        @Nullable
        public String getName();

        @Nullable
        public List<String> getUsers();
    }

    public static interface Guild
    extends ISnowflake {
        @Nullable
        public String getIconId();

        @Nullable
        public String getIconUrl();

        @Nonnull
        public String getName();

        @Nullable
        public String getSplashId();

        @Nullable
        public String getSplashUrl();

        @Nonnull
        public Guild.VerificationLevel getVerificationLevel();

        public int getOnlineCount();

        public int getMemberCount();

        @Nonnull
        public Set<String> getFeatures();
    }

    public static interface Channel
    extends ISnowflake {
        @Nonnull
        public String getName();

        @Nonnull
        public ChannelType getType();
    }
}

