/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.entities;

import github.scarsz.discordsrv.dependencies.jda.annotations.Incubating;
import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.OnlineStatus;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Activity;
import github.scarsz.discordsrv.dependencies.jda.api.entities.ClientType;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Emote;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildVoiceState;
import github.scarsz.discordsrv.dependencies.jda.api.entities.IMentionable;
import github.scarsz.discordsrv.dependencies.jda.api.entities.IPermissionHolder;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.AuditableRestAction;
import java.awt.Color;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Member
extends IMentionable,
IPermissionHolder {
    public static final String AVATAR_URL = "https://cdn.discordapp.com/guilds/%s/users/%s/avatars/%s.%s";

    @Nonnull
    public User getUser();

    @Override
    @Nonnull
    public Guild getGuild();

    @Nonnull
    public JDA getJDA();

    @Nonnull
    public OffsetDateTime getTimeJoined();

    public boolean hasTimeJoined();

    @Nullable
    public OffsetDateTime getTimeBoosted();

    @Nullable
    public GuildVoiceState getVoiceState();

    @Nonnull
    public List<Activity> getActivities();

    @Nonnull
    public OnlineStatus getOnlineStatus();

    @Nonnull
    public OnlineStatus getOnlineStatus(@Nonnull ClientType var1);

    @Nonnull
    public EnumSet<ClientType> getActiveClients();

    @Nullable
    public String getNickname();

    @Nonnull
    public String getEffectiveName();

    @Nullable
    public String getAvatarId();

    @Nullable
    default public String getAvatarUrl() {
        String avatarId = this.getAvatarId();
        return avatarId == null ? null : String.format(AVATAR_URL, this.getGuild().getId(), this.getId(), avatarId, avatarId.startsWith("a_") ? "gif" : "png");
    }

    @Nonnull
    default public String getEffectiveAvatarUrl() {
        String avatarUrl = this.getAvatarUrl();
        return avatarUrl == null ? this.getUser().getEffectiveAvatarUrl() : avatarUrl;
    }

    @Nonnull
    public List<Role> getRoles();

    @Nullable
    public Color getColor();

    public int getColorRaw();

    public boolean canInteract(@Nonnull Member var1);

    public boolean canInteract(@Nonnull Role var1);

    public boolean canInteract(@Nonnull Emote var1);

    public boolean isOwner();

    @Incubating
    public boolean isPending();

    @Nullable
    public TextChannel getDefaultChannel();

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> ban(int delDays) {
        return this.getGuild().ban(this, delDays);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> ban(int delDays, @Nullable String reason) {
        return this.getGuild().ban(this, delDays, reason);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> kick() {
        return this.getGuild().kick(this);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> kick(@Nullable String reason) {
        return this.getGuild().kick(this, reason);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> mute(boolean mute) {
        return this.getGuild().mute(this, mute);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> deafen(boolean deafen) {
        return this.getGuild().deafen(this, deafen);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> modifyNickname(@Nullable String nickname) {
        return this.getGuild().modifyNickname(this, nickname);
    }
}

