/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.entities;

import github.scarsz.discordsrv.dependencies.jda.annotations.DeprecatedSince;
import github.scarsz.discordsrv.dependencies.jda.annotations.ForRemoval;
import github.scarsz.discordsrv.dependencies.jda.annotations.ReplaceWith;
import github.scarsz.discordsrv.dependencies.jda.api.AccountType;
import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.AbstractChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Emote;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageHistory;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.AccountTypeException;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.ActionRow;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.ComponentLayout;
import github.scarsz.discordsrv.dependencies.jda.api.requests.RestAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.AuditableRestAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.MessageAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.pagination.MessagePaginationAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.pagination.ReactionPaginationAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.AttachmentOption;
import github.scarsz.discordsrv.dependencies.jda.api.utils.MiscUtil;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataArray;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.EntityBuilder;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.ReceivedMessage;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.RestActionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.Route;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction.AuditableRestActionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction.MessageActionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction.pagination.MessagePaginationActionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction.pagination.ReactionPaginationActionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.EncodingUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formattable;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface MessageChannel
extends AbstractChannel,
Formattable {
    @Nonnull
    default public String getLatestMessageId() {
        return Long.toUnsignedString(this.getLatestMessageIdLong());
    }

    @Nonnull
    default public List<CompletableFuture<Void>> purgeMessagesById(@Nonnull List<String> messageIds) {
        if (messageIds == null || messageIds.isEmpty()) {
            return Collections.emptyList();
        }
        long[] ids = new long[messageIds.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = MiscUtil.parseSnowflake(messageIds.get(i));
        }
        return this.purgeMessagesById(ids);
    }

    @Nonnull
    default public List<CompletableFuture<Void>> purgeMessagesById(String ... messageIds) {
        if (messageIds == null || messageIds.length == 0) {
            return Collections.emptyList();
        }
        return this.purgeMessagesById(Arrays.asList(messageIds));
    }

    @Nonnull
    default public List<CompletableFuture<Void>> purgeMessages(Message ... messages) {
        if (messages == null || messages.length == 0) {
            return Collections.emptyList();
        }
        return this.purgeMessages(Arrays.asList(messages));
    }

    @Nonnull
    default public List<CompletableFuture<Void>> purgeMessages(@Nonnull List<? extends Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return Collections.emptyList();
        }
        long[] ids = new long[messages.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = messages.get(i).getIdLong();
        }
        return this.purgeMessagesById(ids);
    }

    @Nonnull
    default public List<CompletableFuture<Void>> purgeMessagesById(long ... messageIds) {
        if (messageIds == null || messageIds.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<CompletableFuture<Void>> list = new ArrayList<CompletableFuture<Void>>(messageIds.length);
        TreeSet sortedIds = new TreeSet(Comparator.reverseOrder());
        for (long messageId : messageIds) {
            sortedIds.add(messageId);
        }
        Object object = sortedIds.iterator();
        while (object.hasNext()) {
            long messageId = (Long)object.next();
            list.add(this.deleteMessageById(messageId).submit());
        }
        return list;
    }

    public long getLatestMessageIdLong();

    public boolean hasLatestMessage();

    @Nonnull
    @CheckReturnValue
    default public MessageAction sendMessage(@Nonnull CharSequence text) {
        Checks.notEmpty(text, "Provided text for message");
        Checks.check(text.length() <= 2000, "Provided text for message must be less than %d characters in length", (Object)2000);
        if (text instanceof StringBuilder) {
            return new MessageActionImpl(this.getJDA(), null, this, (StringBuilder)text);
        }
        return new MessageActionImpl(this.getJDA(), null, this).append(text);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction sendMessageFormat(@Nonnull String format, Object ... args) {
        Checks.notEmpty(format, "Format");
        return this.sendMessage(String.format(format, args));
    }

    @Nonnull
    @CheckReturnValue
    @Deprecated
    @ForRemoval(deadline="5.0.0")
    @ReplaceWith(value="sendMessageEmbeds(embed)")
    @DeprecatedSince(value="4.4.0")
    default public MessageAction sendMessage(@Nonnull MessageEmbed embed) {
        Checks.notNull(embed, "Provided embed");
        return new MessageActionImpl(this.getJDA(), null, this).setEmbeds(embed);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction sendMessageEmbeds(@Nonnull MessageEmbed embed, MessageEmbed ... other) {
        Checks.notNull(embed, "MessageEmbeds");
        Checks.noneNull(other, "MessageEmbeds");
        ArrayList<MessageEmbed> embeds = new ArrayList<MessageEmbed>(1 + other.length);
        embeds.add(embed);
        Collections.addAll(embeds, other);
        return new MessageActionImpl(this.getJDA(), null, this).setEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction sendMessageEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        return new MessageActionImpl(this.getJDA(), null, this).setEmbeds((Collection)embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction sendMessage(@Nonnull Message msg) {
        Checks.notNull(msg, "Message");
        return new MessageActionImpl(this.getJDA(), null, this).apply(msg);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction sendFile(@Nonnull File file, AttachmentOption ... options) {
        Checks.notNull(file, "file");
        return this.sendFile(file, file.getName(), options);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction sendFile(@Nonnull File file, @Nonnull String fileName, AttachmentOption ... options) {
        Checks.notNull(file, "file");
        Checks.check(file.exists() && file.canRead(), "Provided file doesn't exist or cannot be read!");
        Checks.notNull(fileName, "fileName");
        try {
            return this.sendFile(new FileInputStream(file), fileName, options);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction sendFile(@Nonnull InputStream data, @Nonnull String fileName, AttachmentOption ... options) {
        Checks.notNull(data, "data InputStream");
        Checks.notNull(fileName, "fileName");
        return new MessageActionImpl(this.getJDA(), null, this).addFile(data, fileName, options);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction sendFile(@Nonnull byte[] data, @Nonnull String fileName, AttachmentOption ... options) {
        Checks.notNull(data, "data");
        Checks.notNull(fileName, "fileName");
        return this.sendFile(new ByteArrayInputStream(data), fileName, options);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Message> retrieveMessageById(@Nonnull String messageId) {
        AccountTypeException.check(this.getJDA().getAccountType(), AccountType.BOT);
        Checks.isSnowflake(messageId, "Message ID");
        JDAImpl jda = (JDAImpl)this.getJDA();
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE.compile(this.getId(), messageId);
        return new RestActionImpl<Message>((JDA)jda, route, (response, request) -> jda.getEntityBuilder().createMessage(response.getObject(), this, false));
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Message> retrieveMessageById(long messageId) {
        return this.retrieveMessageById(Long.toUnsignedString(messageId));
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> deleteMessageById(@Nonnull String messageId) {
        Checks.isSnowflake(messageId, "Message ID");
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGE.compile(this.getId(), messageId);
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> deleteMessageById(long messageId) {
        return this.deleteMessageById(Long.toUnsignedString(messageId));
    }

    default public MessageHistory getHistory() {
        return new MessageHistory(this);
    }

    @Nonnull
    @CheckReturnValue
    default public MessagePaginationAction getIterableHistory() {
        return new MessagePaginationActionImpl(this);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAround(@Nonnull String messageId, int limit) {
        return MessageHistory.getHistoryAround(this, messageId).limit(limit);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAround(long messageId, int limit) {
        return this.getHistoryAround(Long.toUnsignedString(messageId), limit);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAround(@Nonnull Message message, int limit) {
        Checks.notNull(message, "Provided target message");
        return this.getHistoryAround(message.getId(), limit);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAfter(@Nonnull String messageId, int limit) {
        return MessageHistory.getHistoryAfter(this, messageId).limit(limit);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAfter(long messageId, int limit) {
        return this.getHistoryAfter(Long.toUnsignedString(messageId), limit);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAfter(@Nonnull Message message, int limit) {
        Checks.notNull(message, "Message");
        return this.getHistoryAfter(message.getId(), limit);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryBefore(@Nonnull String messageId, int limit) {
        return MessageHistory.getHistoryBefore(this, messageId).limit(limit);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryBefore(long messageId, int limit) {
        return this.getHistoryBefore(Long.toUnsignedString(messageId), limit);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryBefore(@Nonnull Message message, int limit) {
        Checks.notNull(message, "Message");
        return this.getHistoryBefore(message.getId(), limit);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryFromBeginning(int limit) {
        return MessageHistory.getHistoryFromBeginning(this).limit(limit);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> sendTyping() {
        Route.CompiledRoute route = Route.Channels.SEND_TYPING.compile(this.getId());
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> addReactionById(@Nonnull String messageId, @Nonnull String unicode) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notNull(unicode, "Provided Unicode");
        unicode = unicode.trim();
        Checks.notEmpty(unicode, "Provided Unicode");
        String encoded = EncodingUtil.encodeReaction(unicode);
        Route.CompiledRoute route = Route.Messages.ADD_REACTION.compile(this.getId(), messageId, encoded, "@me");
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> addReactionById(long messageId, @Nonnull String unicode) {
        return this.addReactionById(Long.toUnsignedString(messageId), unicode);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> addReactionById(@Nonnull String messageId, @Nonnull Emote emote) {
        Checks.notNull(emote, "Emote");
        return this.addReactionById(messageId, emote.getName() + ":" + emote.getId());
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> addReactionById(long messageId, @Nonnull Emote emote) {
        return this.addReactionById(Long.toUnsignedString(messageId), emote);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> removeReactionById(@Nonnull String messageId, @Nonnull String unicode) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notNull(unicode, "Provided Unicode");
        unicode = unicode.trim();
        Checks.notEmpty(unicode, "Provided Unicode");
        String encoded = EncodingUtil.encodeReaction(unicode);
        Route.CompiledRoute route = Route.Messages.REMOVE_REACTION.compile(this.getId(), messageId, encoded, "@me");
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> removeReactionById(long messageId, @Nonnull String unicode) {
        return this.removeReactionById(Long.toUnsignedString(messageId), unicode);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> removeReactionById(@Nonnull String messageId, @Nonnull Emote emote) {
        Checks.notNull(emote, "Emote");
        return this.removeReactionById(messageId, emote.getName() + ":" + emote.getId());
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> removeReactionById(long messageId, @Nonnull Emote emote) {
        return this.removeReactionById(Long.toUnsignedString(messageId), emote);
    }

    @Nonnull
    @CheckReturnValue
    default public ReactionPaginationAction retrieveReactionUsersById(@Nonnull String messageId, @Nonnull String unicode) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notEmpty(unicode, "Emoji");
        Checks.noWhitespace(unicode, "Emoji");
        return new ReactionPaginationActionImpl(this, messageId, EncodingUtil.encodeReaction(unicode));
    }

    @Nonnull
    @CheckReturnValue
    default public ReactionPaginationAction retrieveReactionUsersById(long messageId, @Nonnull String unicode) {
        return this.retrieveReactionUsersById(Long.toUnsignedString(messageId), unicode);
    }

    @Nonnull
    @CheckReturnValue
    default public ReactionPaginationAction retrieveReactionUsersById(@Nonnull String messageId, @Nonnull Emote emote) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notNull(emote, "Emote");
        return new ReactionPaginationActionImpl(this, messageId, String.format("%s:%s", emote, emote.getId()));
    }

    @Nonnull
    @CheckReturnValue
    default public ReactionPaginationAction retrieveReactionUsersById(long messageId, @Nonnull Emote emote) {
        return this.retrieveReactionUsersById(Long.toUnsignedString(messageId), emote);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> pinMessageById(@Nonnull String messageId) {
        Checks.isSnowflake(messageId, "Message ID");
        Route.CompiledRoute route = Route.Messages.ADD_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> pinMessageById(long messageId) {
        return this.pinMessageById(Long.toUnsignedString(messageId));
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> unpinMessageById(@Nonnull String messageId) {
        Checks.isSnowflake(messageId, "Message ID");
        Route.CompiledRoute route = Route.Messages.REMOVE_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> unpinMessageById(long messageId) {
        return this.unpinMessageById(Long.toUnsignedString(messageId));
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<List<Message>> retrievePinnedMessages() {
        JDAImpl jda = (JDAImpl)this.getJDA();
        Route.CompiledRoute route = Route.Messages.GET_PINNED_MESSAGES.compile(this.getId());
        return new RestActionImpl<List<Message>>((JDA)jda, route, (response, request) -> {
            LinkedList<ReceivedMessage> pinnedMessages = new LinkedList<ReceivedMessage>();
            EntityBuilder builder = jda.getEntityBuilder();
            DataArray pins = response.getArray();
            for (int i = 0; i < pins.length(); ++i) {
                pinnedMessages.add(builder.createMessage(pins.getObject(i), this, false));
            }
            return Collections.unmodifiableList(pinnedMessages);
        });
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageById(@Nonnull String messageId, @Nonnull CharSequence newContent) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notEmpty(newContent, "Provided message content");
        Checks.check(newContent.length() <= 2000, "Provided newContent length must be %d or less characters.", (Object)2000);
        if (newContent instanceof StringBuilder) {
            return new MessageActionImpl(this.getJDA(), messageId, this, (StringBuilder)newContent);
        }
        return new MessageActionImpl(this.getJDA(), messageId, this).append(newContent);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageById(long messageId, @Nonnull CharSequence newContent) {
        return this.editMessageById(Long.toUnsignedString(messageId), newContent);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageById(@Nonnull String messageId, @Nonnull Message newContent) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notNull(newContent, "message");
        return new MessageActionImpl(this.getJDA(), messageId, this).apply(newContent);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageById(long messageId, @Nonnull Message newContent) {
        return this.editMessageById(Long.toUnsignedString(messageId), newContent);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageFormatById(@Nonnull String messageId, @Nonnull String format, Object ... args) {
        Checks.notBlank(format, "Format String");
        return this.editMessageById(messageId, (CharSequence)String.format(format, args));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageFormatById(long messageId, @Nonnull String format, Object ... args) {
        Checks.notBlank(format, "Format String");
        return this.editMessageById(messageId, (CharSequence)String.format(format, args));
    }

    @Nonnull
    @CheckReturnValue
    @Deprecated
    @ForRemoval(deadline="5.0.0")
    @ReplaceWith(value="editMessageEmbedsById(messageId, newEmbed)")
    @DeprecatedSince(value="4.4.0")
    default public MessageAction editMessageById(@Nonnull String messageId, @Nonnull MessageEmbed newEmbed) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notNull(newEmbed, "MessageEmbed");
        return new MessageActionImpl(this.getJDA(), messageId, this).setEmbeds(newEmbed);
    }

    @Nonnull
    @CheckReturnValue
    @Deprecated
    @ForRemoval(deadline="5.0.0")
    @ReplaceWith(value="editMessageEmbedsById(messageId, newEmbed)")
    @DeprecatedSince(value="4.4.0")
    default public MessageAction editMessageById(long messageId, @Nonnull MessageEmbed newEmbed) {
        return this.editMessageById(Long.toUnsignedString(messageId), newEmbed);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageEmbedsById(@Nonnull String messageId, MessageEmbed ... newEmbeds) {
        Checks.noneNull(newEmbeds, "MessageEmbeds");
        return this.editMessageEmbedsById(messageId, Arrays.asList(newEmbeds));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageEmbedsById(long messageId, MessageEmbed ... newEmbeds) {
        return this.editMessageEmbedsById(Long.toUnsignedString(messageId), newEmbeds);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageEmbedsById(@Nonnull String messageId, @Nonnull Collection<? extends MessageEmbed> newEmbeds) {
        Checks.isSnowflake(messageId, "Message ID");
        return new MessageActionImpl(this.getJDA(), messageId, this).setEmbeds((Collection)newEmbeds);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageEmbedsById(long messageId, @Nonnull Collection<? extends MessageEmbed> newEmbeds) {
        return this.editMessageEmbedsById(Long.toUnsignedString(messageId), newEmbeds);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageComponentsById(@Nonnull String messageId, @Nonnull Collection<? extends ComponentLayout> components) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.noneNull(components, "Components");
        if (components.stream().anyMatch(x -> !(x instanceof ActionRow))) {
            throw new UnsupportedOperationException("The provided component layout is not supported");
        }
        List actionRows = components.stream().map(ActionRow.class::cast).collect(Collectors.toList());
        return new MessageActionImpl(this.getJDA(), messageId, this).setActionRows(actionRows);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageComponentsById(long messageId, @Nonnull Collection<? extends ComponentLayout> components) {
        return this.editMessageComponentsById(Long.toUnsignedString(messageId), components);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageComponentsById(@Nonnull String messageId, ComponentLayout ... components) {
        Checks.noneNull(components, "Components");
        return this.editMessageComponentsById(messageId, Arrays.asList(components));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageComponentsById(long messageId, ComponentLayout ... components) {
        Checks.noneNull(components, "Components");
        return this.editMessageComponentsById(messageId, Arrays.asList(components));
    }

    @Override
    default public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String out;
        boolean leftJustified = (flags & 1) == 1;
        boolean upper = (flags & 2) == 2;
        boolean alt = (flags & 4) == 4;
        String string = out = upper ? this.getName().toUpperCase(formatter.locale()) : this.getName();
        if (alt) {
            out = "#" + out;
        }
        MiscUtil.appendTo(formatter, width, precision, leftJustified, out);
    }
}

