/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.entities;

import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageChannel;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.InsufficientPermissionException;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.MissingAccessException;
import github.scarsz.discordsrv.dependencies.jda.api.requests.RestAction;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.ReceivedMessage;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.CompletedRestAction;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.RestActionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.Route;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MessageReference {
    private final long messageId;
    private final long channelId;
    private final long guildId;
    private final JDA api;
    private final MessageChannel channel;
    private final Guild guild;
    private Message referencedMessage;

    public MessageReference(long messageId, long channelId, long guildId, @Nullable Message referencedMessage, JDA api) {
        GuildChannel guildChannel;
        this.messageId = messageId;
        this.channelId = channelId;
        this.guildId = guildId;
        this.referencedMessage = referencedMessage;
        this.channel = guildId == 0L ? api.getPrivateChannelById(channelId) : ((guildChannel = api.getGuildChannelById(channelId)) instanceof MessageChannel ? (MessageChannel)((Object)guildChannel) : null);
        this.guild = api.getGuildById(guildId);
        this.api = api;
    }

    @Nonnull
    public RestAction<Message> resolve() {
        return this.resolve(true);
    }

    @Nonnull
    public RestAction<Message> resolve(boolean update) {
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_HISTORY);
        if (this.channel == null) {
            throw new IllegalStateException("Cannot resolve a message without a channel present.");
        }
        JDAImpl jda = (JDAImpl)this.getJDA();
        Message referenced = this.getMessage();
        if (referenced != null && !update) {
            return new CompletedRestAction<Message>((JDA)jda, referenced);
        }
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE.compile(this.getChannelId(), this.getMessageId());
        return new RestActionImpl<Message>((JDA)jda, route, (response, request) -> {
            ReceivedMessage created = jda.getEntityBuilder().createMessage(response.getObject(), this.getChannel(), false);
            this.referencedMessage = created;
            return created;
        });
    }

    @Nullable
    public Message getMessage() {
        return this.referencedMessage;
    }

    @Nullable
    public MessageChannel getChannel() {
        return this.channel;
    }

    @Nullable
    public Guild getGuild() {
        return this.guild;
    }

    public long getMessageIdLong() {
        return this.messageId;
    }

    public long getChannelIdLong() {
        return this.channelId;
    }

    public long getGuildIdLong() {
        return this.guildId;
    }

    @Nonnull
    public String getMessageId() {
        return Long.toUnsignedString(this.getMessageIdLong());
    }

    @Nonnull
    public String getChannelId() {
        return Long.toUnsignedString(this.getChannelIdLong());
    }

    @Nonnull
    public String getGuildId() {
        return Long.toUnsignedString(this.getGuildIdLong());
    }

    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    private void checkPermission(Permission permission) {
        GuildChannel guildChannel;
        if (this.guild == null || !(this.channel instanceof GuildChannel)) {
            return;
        }
        Member selfMember = this.guild.getSelfMember();
        if (!selfMember.hasAccess(guildChannel = (GuildChannel)((Object)this.channel))) {
            throw new MissingAccessException(guildChannel, Permission.VIEW_CHANNEL);
        }
        if (!selfMember.hasPermission(guildChannel, permission)) {
            throw new InsufficientPermissionException(guildChannel, permission);
        }
    }
}

