/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.entities;

import github.scarsz.discordsrv.dependencies.jda.annotations.DeprecatedSince;
import github.scarsz.discordsrv.dependencies.jda.annotations.ForRemoval;
import github.scarsz.discordsrv.dependencies.jda.annotations.ReplaceWith;
import github.scarsz.discordsrv.dependencies.jda.api.entities.ISnowflake;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Helpers;
import java.util.Set;
import javax.annotation.Nonnull;

public class MessageSticker
implements ISnowflake {
    private final long id;
    private final String name;
    private final String description;
    private final long packId;
    private final String asset;
    private final StickerFormat formatType;
    private final Set<String> tags;
    @Deprecated
    @ForRemoval(deadline="5.0.0")
    @ReplaceWith(value="ICON_URL")
    @DeprecatedSince(value="4.3.1")
    public static final String ASSET_URL = "https://cdn.discordapp.com/stickers/%s/%s.%s";
    public static final String ICON_URL = "https://cdn.discordapp.com/stickers/%s.%s";

    public MessageSticker(long id, String name, String description, long packId, String asset, StickerFormat formatType, Set<String> tags) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.packId = packId;
        this.asset = asset;
        this.formatType = formatType;
        this.tags = tags;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getPackId() {
        return Long.toUnsignedString(this.getPackIdLong());
    }

    public long getPackIdLong() {
        return this.packId;
    }

    @Nonnull
    @Deprecated
    @ForRemoval(deadline="5.0.0")
    @ReplaceWith(value="getIconUrl()")
    @DeprecatedSince(value="4.3.1")
    public String getAssetHash() {
        return this.asset;
    }

    @Nonnull
    @Deprecated
    @ForRemoval(deadline="5.0.0")
    @ReplaceWith(value="getIconUrl()")
    @DeprecatedSince(value="4.3.1")
    public String getAssetUrl() {
        return String.format(ASSET_URL, this.id, this.asset, this.formatType.getExtension());
    }

    @Nonnull
    public String getIconUrl() {
        return Helpers.format(ICON_URL, this.getId(), this.formatType.getExtension());
    }

    @Nonnull
    public StickerFormat getFormatType() {
        return this.formatType;
    }

    @Nonnull
    public Set<String> getTags() {
        return this.tags;
    }

    public static enum StickerFormat {
        PNG(1, "png"),
        APNG(2, "apng"),
        LOTTIE(3, "json"),
        UNKNOWN(-1, null);

        private final int id;
        private final String extension;

        private StickerFormat(int id, String extension) {
            this.id = id;
            this.extension = extension;
        }

        @Nonnull
        public String getExtension() {
            if (this == UNKNOWN) {
                throw new IllegalStateException("Can only get extension of a known format");
            }
            return this.extension;
        }

        @Nonnull
        public static StickerFormat fromId(int id) {
            for (StickerFormat stickerFormat : StickerFormat.values()) {
                if (stickerFormat.id != id) continue;
                return stickerFormat;
            }
            return UNKNOWN;
        }
    }
}

