/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.events;

import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.events.Event;
import github.scarsz.discordsrv.dependencies.jda.api.requests.CloseCode;
import github.scarsz.discordsrv.dependencies.ws.client.WebSocketFrame;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DisconnectEvent
extends Event {
    protected final WebSocketFrame serverCloseFrame;
    protected final WebSocketFrame clientCloseFrame;
    protected final boolean closedByServer;
    protected final OffsetDateTime disconnectTime;

    public DisconnectEvent(@Nonnull JDA api, @Nullable WebSocketFrame serverCloseFrame, @Nullable WebSocketFrame clientCloseFrame, boolean closedByServer, @Nonnull OffsetDateTime disconnectTime) {
        super(api);
        this.serverCloseFrame = serverCloseFrame;
        this.clientCloseFrame = clientCloseFrame;
        this.closedByServer = closedByServer;
        this.disconnectTime = disconnectTime;
    }

    @Nullable
    public CloseCode getCloseCode() {
        return this.serverCloseFrame != null ? CloseCode.from(this.serverCloseFrame.getCloseCode()) : null;
    }

    @Nullable
    public WebSocketFrame getServiceCloseFrame() {
        return this.serverCloseFrame;
    }

    @Nullable
    public WebSocketFrame getClientCloseFrame() {
        return this.clientCloseFrame;
    }

    public boolean isClosedByServer() {
        return this.closedByServer;
    }

    @Nonnull
    public OffsetDateTime getTimeDisconnected() {
        return this.disconnectTime;
    }
}

