/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.events.guild.update;

import github.scarsz.discordsrv.dependencies.jda.annotations.DeprecatedSince;
import github.scarsz.discordsrv.dependencies.jda.annotations.ForRemoval;
import github.scarsz.discordsrv.dependencies.jda.annotations.ReplaceWith;
import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.update.GenericGuildUpdateEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GuildUpdateBannerEvent
extends GenericGuildUpdateEvent<String> {
    public static final String IDENTIFIER = "banner";

    public GuildUpdateBannerEvent(@Nonnull JDA api, long responseNumber, @Nonnull Guild guild, @Nullable String previous) {
        super(api, responseNumber, guild, previous, guild.getBannerId(), IDENTIFIER);
    }

    @Nullable
    public String getNewBannerId() {
        return (String)this.getNewValue();
    }

    @Nullable
    public String getNewBannerUrl() {
        return this.next == null ? null : String.format("https://cdn.discordapp.com/banners/%s/%s.png", this.guild.getId(), this.next);
    }

    @Nullable
    @Deprecated
    @ForRemoval(deadline="5.0.0")
    @DeprecatedSince(value="4.2.0")
    @ReplaceWith(value="getNewBannerUrl()")
    public String getNewBannerIdUrl() {
        return this.getNewBannerUrl();
    }

    @Nullable
    public String getOldBannerId() {
        return (String)this.getOldValue();
    }

    @Nullable
    public String getOldBannerUrl() {
        return this.previous == null ? null : String.format("https://cdn.discordapp.com/banners/%s/%s.png", this.guild.getId(), this.previous);
    }
}

