/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.events.message.priv.react;

import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageReaction;
import github.scarsz.discordsrv.dependencies.jda.api.entities.PrivateChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.events.message.priv.GenericPrivateMessageEvent;
import github.scarsz.discordsrv.dependencies.jda.api.requests.RestAction;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.CompletedRestAction;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GenericPrivateMessageReactionEvent
extends GenericPrivateMessageEvent {
    protected final long userId;
    protected final MessageReaction reaction;

    public GenericPrivateMessageReactionEvent(@Nonnull JDA api, long responseNumber, @Nonnull MessageReaction reaction, long userId) {
        super(api, responseNumber, reaction.getMessageIdLong(), (PrivateChannel)reaction.getChannel());
        this.userId = userId;
        this.reaction = reaction;
    }

    @Nonnull
    public String getUserId() {
        return Long.toUnsignedString(this.userId);
    }

    public long getUserIdLong() {
        return this.userId;
    }

    @Nullable
    public User getUser() {
        return this.userId == this.getJDA().getSelfUser().getIdLong() ? this.getJDA().getSelfUser() : this.getChannel().getUser();
    }

    @Nonnull
    public MessageReaction getReaction() {
        return this.reaction;
    }

    @Nonnull
    public MessageReaction.ReactionEmote getReactionEmote() {
        return this.reaction.getReactionEmote();
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<User> retrieveUser() {
        User user = this.getUser();
        if (user != null) {
            return new CompletedRestAction<User>(this.getJDA(), user);
        }
        return this.getJDA().retrieveUserById(this.getUserIdLong());
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Message> retrieveMessage() {
        return this.getChannel().retrieveMessageById(this.getMessageId());
    }
}

