/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.events.user;

import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.ChannelType;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.PrivateChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.events.user.GenericUserEvent;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserTypingEvent
extends GenericUserEvent {
    private final Member member;
    private final MessageChannel channel;
    private final OffsetDateTime timestamp;

    public UserTypingEvent(@Nonnull JDA api, long responseNumber, @Nonnull User user, @Nonnull MessageChannel channel, @Nonnull OffsetDateTime timestamp, @Nullable Member member) {
        super(api, responseNumber, user);
        this.member = member;
        this.channel = channel;
        this.timestamp = timestamp;
    }

    @Nonnull
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @Nonnull
    public MessageChannel getChannel() {
        return this.channel;
    }

    public boolean isFromType(@Nonnull ChannelType type) {
        return this.channel.getType() == type;
    }

    @Nonnull
    public ChannelType getType() {
        return this.channel.getType();
    }

    @Nullable
    public PrivateChannel getPrivateChannel() {
        return this.isFromType(ChannelType.PRIVATE) ? (PrivateChannel)this.channel : null;
    }

    @Nullable
    public TextChannel getTextChannel() {
        return this.isFromType(ChannelType.TEXT) ? (TextChannel)this.channel : null;
    }

    @Nullable
    public Guild getGuild() {
        return this.isFromType(ChannelType.TEXT) ? this.member.getGuild() : null;
    }

    @Nullable
    public Member getMember() {
        return this.member;
    }
}

