/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.interactions.commands;

import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.Interaction;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.OptionMapping;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.OptionType;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface CommandInteraction
extends Interaction {
    @Nonnull
    public String getName();

    @Nullable
    public String getSubcommandName();

    @Nullable
    public String getSubcommandGroup();

    @Nonnull
    default public String getCommandPath() {
        StringBuilder builder = new StringBuilder(this.getName());
        if (this.getSubcommandGroup() != null) {
            builder.append('/').append(this.getSubcommandGroup());
        }
        if (this.getSubcommandName() != null) {
            builder.append('/').append(this.getSubcommandName());
        }
        return builder.toString();
    }

    @Override
    @Nonnull
    public MessageChannel getChannel();

    public long getCommandIdLong();

    @Nonnull
    default public String getCommandId() {
        return Long.toUnsignedString(this.getCommandIdLong());
    }

    @Nonnull
    public List<OptionMapping> getOptions();

    @Nonnull
    default public List<OptionMapping> getOptionsByName(@Nonnull String name) {
        Checks.notNull(name, "Name");
        return this.getOptions().stream().filter(opt -> opt.getName().equals(name)).collect(Collectors.toList());
    }

    @Nonnull
    default public List<OptionMapping> getOptionsByType(@Nonnull OptionType type) {
        Checks.notNull((Object)type, "Type");
        return this.getOptions().stream().filter(it -> it.getType() == type).collect(Collectors.toList());
    }

    @Nullable
    default public OptionMapping getOption(@Nonnull String name) {
        List<OptionMapping> options = this.getOptionsByName(name);
        return options.isEmpty() ? null : options.get(0);
    }

    @Nonnull
    default public String getCommandString() {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(this.getName());
        if (this.getSubcommandGroup() != null) {
            builder.append(" ").append(this.getSubcommandGroup());
        }
        if (this.getSubcommandName() != null) {
            builder.append(" ").append(this.getSubcommandName());
        }
        block6: for (OptionMapping o : this.getOptions()) {
            builder.append(" ").append(o.getName()).append(": ");
            switch (o.getType()) {
                case CHANNEL: {
                    builder.append("#").append(o.getAsGuildChannel().getName());
                    continue block6;
                }
                case USER: {
                    builder.append("@").append(o.getAsUser().getName());
                    continue block6;
                }
                case ROLE: {
                    builder.append("@").append(o.getAsRole().getName());
                    continue block6;
                }
                case MENTIONABLE: {
                    if (o.getAsMentionable() instanceof Role) {
                        builder.append("@").append(o.getAsRole().getName());
                        continue block6;
                    }
                    if (o.getAsMentionable() instanceof Member) {
                        builder.append("@").append(o.getAsUser().getName());
                        continue block6;
                    }
                    if (o.getAsMentionable() instanceof User) {
                        builder.append("@").append(o.getAsUser().getName());
                        continue block6;
                    }
                    builder.append("@").append(o.getAsMentionable().getIdLong());
                    continue block6;
                }
            }
            builder.append(o.getAsString());
        }
        return builder.toString();
    }
}

