/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.build;

import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.OptionType;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.build.OptionData;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataArray;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.SerializableData;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class BaseCommand<T extends BaseCommand<T>>
implements SerializableData {
    protected final DataArray options = DataArray.empty();
    protected String name;
    protected String description;

    public BaseCommand(@Nonnull String name, @Nonnull String description) {
        Checks.notEmpty(name, "Name");
        Checks.notEmpty(description, "Description");
        Checks.notLonger(name, 32, "Name");
        Checks.notLonger(description, 100, "Description");
        Checks.matches(name, Checks.ALPHANUMERIC_WITH_DASH, "Name");
        Checks.isLowercase(name, "Name");
        this.name = name;
        this.description = description;
    }

    @Nonnull
    public T setName(@Nonnull String name) {
        Checks.notEmpty(name, "Name");
        Checks.notLonger(name, 32, "Name");
        Checks.isLowercase(name, "Name");
        Checks.matches(name, Checks.ALPHANUMERIC_WITH_DASH, "Name");
        this.name = name;
        return (T)this;
    }

    @Nonnull
    public T setDescription(@Nonnull String description) {
        Checks.notEmpty(description, "Description");
        Checks.notLonger(description, 100, "Description");
        this.description = description;
        return (T)this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public List<OptionData> getOptions() {
        return this.options.stream(DataArray::getObject).map(OptionData::fromData).filter(it -> it.getType().getKey() > OptionType.SUB_COMMAND_GROUP.getKey()).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public DataObject toData() {
        return DataObject.empty().put("name", this.name).put("description", this.description).put("options", this.options);
    }
}

