/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.managers;

import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.PermissionOverride;
import github.scarsz.discordsrv.dependencies.jda.api.managers.Manager;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import java.util.Collection;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface PermOverrideManager
extends Manager<PermOverrideManager> {
    public static final long DENIED = 1L;
    public static final long ALLOWED = 2L;
    public static final long PERMISSIONS = 3L;

    @Override
    @Nonnull
    public PermOverrideManager reset(long var1);

    @Override
    @Nonnull
    public PermOverrideManager reset(long ... var1);

    @Nonnull
    default public Guild getGuild() {
        return this.getPermissionOverride().getGuild();
    }

    @Nonnull
    default public GuildChannel getChannel() {
        return this.getPermissionOverride().getChannel();
    }

    @Nonnull
    public PermissionOverride getPermissionOverride();

    @Nonnull
    @CheckReturnValue
    public PermOverrideManager grant(long var1);

    @Nonnull
    @CheckReturnValue
    default public PermOverrideManager grant(Permission ... permissions) {
        Checks.notNull(permissions, "Permissions");
        return this.grant(Permission.getRaw(permissions));
    }

    @Nonnull
    @CheckReturnValue
    default public PermOverrideManager grant(@Nonnull Collection<Permission> permissions) {
        return this.grant(Permission.getRaw(permissions));
    }

    @Nonnull
    @CheckReturnValue
    public PermOverrideManager deny(long var1);

    @Nonnull
    @CheckReturnValue
    default public PermOverrideManager deny(Permission ... permissions) {
        Checks.notNull(permissions, "Permissions");
        return this.deny(Permission.getRaw(permissions));
    }

    @Nonnull
    @CheckReturnValue
    default public PermOverrideManager deny(@Nonnull Collection<Permission> permissions) {
        return this.deny(Permission.getRaw(permissions));
    }

    @Nonnull
    @CheckReturnValue
    public PermOverrideManager clear(long var1);

    @Nonnull
    @CheckReturnValue
    default public PermOverrideManager clear(Permission ... permissions) {
        Checks.notNull(permissions, "Permissions");
        return this.clear(Permission.getRaw(permissions));
    }

    @Nonnull
    @CheckReturnValue
    default public PermOverrideManager clear(@Nonnull Collection<Permission> permissions) {
        return this.clear(Permission.getRaw(permissions));
    }
}

