/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.utils;

import github.scarsz.discordsrv.dependencies.jda.annotations.Incubating;
import github.scarsz.discordsrv.dependencies.jda.api.OnlineStatus;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildVoiceState;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface MemberCachePolicy {
    public static final MemberCachePolicy NONE = member -> false;
    public static final MemberCachePolicy ALL = member -> true;
    public static final MemberCachePolicy OWNER = Member::isOwner;
    public static final MemberCachePolicy ONLINE = member -> member.getOnlineStatus() != OnlineStatus.OFFLINE && member.getOnlineStatus() != OnlineStatus.UNKNOWN;
    public static final MemberCachePolicy VOICE = member -> {
        GuildVoiceState voiceState = member.getVoiceState();
        return voiceState != null && voiceState.getChannel() != null;
    };
    @Incubating
    public static final MemberCachePolicy PENDING = Member::isPending;
    public static final MemberCachePolicy DEFAULT = VOICE.or(OWNER);

    public boolean cacheMember(@Nonnull Member var1);

    @Nonnull
    default public MemberCachePolicy or(@Nonnull MemberCachePolicy policy) {
        Checks.notNull(policy, "Policy");
        return member -> this.cacheMember(member) || policy.cacheMember(member);
    }

    @Nonnull
    default public MemberCachePolicy and(@Nonnull MemberCachePolicy policy) {
        return member -> this.cacheMember(member) && policy.cacheMember(member);
    }

    @Nonnull
    public static MemberCachePolicy any(@Nonnull MemberCachePolicy policy, MemberCachePolicy ... policies) {
        Checks.notNull(policy, "Policy");
        Checks.notNull(policies, "Policy");
        for (MemberCachePolicy p : policies) {
            policy = policy.or(p);
        }
        return policy;
    }

    @Nonnull
    public static MemberCachePolicy all(@Nonnull MemberCachePolicy policy, MemberCachePolicy ... policies) {
        Checks.notNull(policy, "Policy");
        Checks.notNull(policies, "Policy");
        for (MemberCachePolicy p : policies) {
            policy = policy.and(p);
        }
        return policy;
    }
}

