/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.api.utils;

import github.scarsz.discordsrv.dependencies.jda.annotations.DeprecatedSince;
import github.scarsz.discordsrv.dependencies.jda.annotations.ForRemoval;
import github.scarsz.discordsrv.dependencies.jda.annotations.ReplaceWith;
import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.tuple.Pair;
import javax.annotation.Nonnull;

public interface SessionController {
    public static final int IDENTIFY_DELAY = 5;

    default public void setConcurrency(int level) {
    }

    public void appendSession(@Nonnull SessionConnectNode var1);

    public void removeSession(@Nonnull SessionConnectNode var1);

    public long getGlobalRatelimit();

    public void setGlobalRatelimit(long var1);

    @Nonnull
    public String getGateway(@Nonnull JDA var1);

    @Nonnull
    @Deprecated
    @ForRemoval(deadline="4.4.0")
    @DeprecatedSince(value="4.0.0")
    @ReplaceWith(value="getShardedGateway(api)")
    public Pair<String, Integer> getGatewayBot(@Nonnull JDA var1);

    @Nonnull
    default public ShardedGateway getShardedGateway(@Nonnull JDA api) {
        Pair<String, Integer> tuple = this.getGatewayBot(api);
        return new ShardedGateway(tuple.getLeft(), tuple.getRight());
    }

    public static interface SessionConnectNode {
        public boolean isReconnect();

        @Nonnull
        public JDA getJDA();

        @Nonnull
        public JDA.ShardInfo getShardInfo();

        public void run(boolean var1) throws InterruptedException;
    }

    public static class ShardedGateway {
        private final String url;
        private final int shardTotal;
        private final int concurrency;

        public ShardedGateway(String url, int shardTotal) {
            this(url, shardTotal, 1);
        }

        public ShardedGateway(String url, int shardTotal, int concurrency) {
            this.url = url;
            this.shardTotal = shardTotal;
            this.concurrency = concurrency;
        }

        public String getUrl() {
            return this.url;
        }

        public int getShardTotal() {
            return this.shardTotal;
        }

        public int getConcurrency() {
            return this.concurrency;
        }
    }
}

