/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.entities;

import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.PrivateChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.requests.RestAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.MiscUtil;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.PrivateChannelImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.UserById;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.DeferredRestAction;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.RestActionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.Route;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserImpl
extends UserById
implements User {
    protected final JDAImpl api;
    protected String discriminator;
    protected String name;
    protected String displayName;
    protected String avatarId;
    protected User.Profile profile;
    protected long privateChannel = 0L;
    protected boolean bot;
    protected boolean system;
    protected boolean fake = false;
    protected int flags;

    public UserImpl(long id, JDAImpl api) {
        super(id);
        this.api = api;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Nonnull
    public String getDiscriminator() {
        return this.discriminator;
    }

    @Override
    public String getAvatarId() {
        return this.avatarId;
    }

    @Override
    @Nonnull
    public RestAction<User.Profile> retrieveProfile() {
        return new DeferredRestAction<User.Profile, RestActionImpl>(this.getJDA(), User.Profile.class, this::getProfile, () -> {
            Route.CompiledRoute route = Route.Users.GET_USER.compile(this.getId());
            return new RestActionImpl<User.Profile>((JDA)this.getJDA(), route, (response, request) -> {
                DataObject json = response.getObject();
                String bannerId = json.getString("banner", null);
                int accentColor = json.getInt("accent_color", 0x1FFFFFFF);
                return new User.Profile(this.getIdLong(), bannerId, accentColor);
            });
        });
    }

    public User.Profile getProfile() {
        return this.profile;
    }

    @Override
    @Nonnull
    public String getDefaultAvatarId() {
        try {
            return String.valueOf(Long.parseLong(this.discriminator) % 5L);
        }
        catch (Throwable ignored) {
            return "0";
        }
    }

    @Override
    @Nonnull
    public String getAsTag() {
        String discriminator = this.getDiscriminator();
        if (discriminator.replace("0", "").isEmpty()) {
            return this.getName();
        }
        return this.getName() + '#' + this.getDiscriminator();
    }

    @Override
    public boolean hasPrivateChannel() {
        return this.privateChannel != 0L;
    }

    @Override
    @Nonnull
    public RestAction<PrivateChannel> openPrivateChannel() {
        return new DeferredRestAction<PrivateChannel, RestActionImpl>(this.getJDA(), PrivateChannel.class, this::getPrivateChannel, () -> {
            Route.CompiledRoute route = Route.Self.CREATE_PRIVATE_CHANNEL.compile(new String[0]);
            DataObject body = DataObject.empty().put("recipient_id", this.getId());
            return new RestActionImpl<PrivateChannel>((JDA)this.getJDA(), route, body, (response, request) -> {
                PrivateChannel priv = this.api.getEntityBuilder().createPrivateChannel(response.getObject(), this);
                this.privateChannel = priv.getIdLong();
                return priv;
            });
        });
    }

    public PrivateChannel getPrivateChannel() {
        if (!this.hasPrivateChannel()) {
            return null;
        }
        PrivateChannel channel = this.getJDA().getPrivateChannelById(this.privateChannel);
        return channel != null ? channel : new PrivateChannelImpl(this.privateChannel, this);
    }

    @Override
    @Nonnull
    public List<Guild> getMutualGuilds() {
        return this.getJDA().getMutualGuilds(this);
    }

    @Override
    public boolean isBot() {
        return this.bot;
    }

    @Override
    public boolean isSystem() {
        return this.system;
    }

    @Override
    @Nonnull
    public JDAImpl getJDA() {
        return this.api;
    }

    @Override
    @Nonnull
    public EnumSet<User.UserFlag> getFlags() {
        return User.UserFlag.getFlags(this.flags);
    }

    @Override
    public int getFlagsRaw() {
        return this.flags;
    }

    @Override
    public String toString() {
        return "U:" + this.getName() + '(' + this.getId() + ')';
    }

    public UserImpl setName(String name) {
        this.name = name;
        return this;
    }

    public UserImpl setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public UserImpl setDiscriminator(String discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public UserImpl setAvatarId(String avatarId) {
        this.avatarId = avatarId;
        return this;
    }

    public UserImpl setProfile(User.Profile profile) {
        this.profile = profile;
        return this;
    }

    public UserImpl setPrivateChannel(PrivateChannel privateChannel) {
        if (privateChannel != null) {
            this.privateChannel = privateChannel.getIdLong();
        }
        return this;
    }

    public UserImpl setBot(boolean bot) {
        this.bot = bot;
        return this;
    }

    public UserImpl setSystem(boolean system) {
        this.system = system;
        return this;
    }

    public UserImpl setFake(boolean fake) {
        this.fake = fake;
        return this;
    }

    public UserImpl setFlags(int flags) {
        this.flags = flags;
        return this;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        boolean leftJustified;
        boolean alt = (flags & 4) == 4;
        boolean upper = (flags & 2) == 2;
        boolean bl = leftJustified = (flags & 1) == 1;
        String out = !alt ? this.getAsMention() : (upper ? this.getAsTag().toUpperCase() : this.getAsTag());
        MiscUtil.appendTo(formatter, width, precision, leftJustified, out);
    }
}

