/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.entities;

import github.scarsz.discordsrv.dependencies.jda.api.Region;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Category;
import github.scarsz.discordsrv.dependencies.jda.api.entities.ChannelType;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.PermissionOverride;
import github.scarsz.discordsrv.dependencies.jda.api.entities.VoiceChannel;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.ChannelAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.MiscUtil;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.AbstractChannelImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.GuildImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import github.scarsz.discordsrv.dependencies.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VoiceChannelImpl
extends AbstractChannelImpl<VoiceChannel, VoiceChannelImpl>
implements VoiceChannel {
    private final TLongObjectMap<Member> connectedMembers = MiscUtil.newLongMap();
    private int userLimit;
    private int bitrate;
    private String region;

    public VoiceChannelImpl(long id, GuildImpl guild) {
        super(id, guild);
    }

    @Override
    public VoiceChannelImpl setPosition(int rawPosition) {
        this.getGuild().getVoiceChannelsView().clearCachedLists();
        return (VoiceChannelImpl)super.setPosition(rawPosition);
    }

    @Override
    public int getUserLimit() {
        return this.userLimit;
    }

    @Override
    public int getBitrate() {
        return this.bitrate;
    }

    @Override
    @Nonnull
    public ChannelType getType() {
        return ChannelType.VOICE;
    }

    @Override
    @Nonnull
    public Region getRegion() {
        return this.region == null ? Region.AUTOMATIC : Region.fromKey(this.region);
    }

    @Override
    @Nullable
    public String getRegionRaw() {
        return this.region;
    }

    @Override
    @Nonnull
    public List<Member> getMembers() {
        return Collections.unmodifiableList(new ArrayList<Member>(this.getConnectedMembersMap().valueCollection()));
    }

    @Override
    public int getPosition() {
        List<VoiceChannel> channels = this.getGuild().getVoiceChannels();
        for (int i = 0; i < channels.size(); ++i) {
            if (!this.equals(channels.get(i))) continue;
            return i;
        }
        throw new IllegalStateException("Somehow when determining position we never found the VoiceChannel in the Guild's channels? wtf?");
    }

    @Override
    @Nonnull
    public ChannelAction<VoiceChannel> createCopy(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<VoiceChannel> action = guild.createVoiceChannel(this.name).setBitrate(this.bitrate).setUserlimit(this.userLimit);
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParent();
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.overrides.valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addMemberPermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addRolePermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof VoiceChannel)) {
            return false;
        }
        VoiceChannel oVChannel = (VoiceChannel)o;
        return this == oVChannel || this.getIdLong() == oVChannel.getIdLong();
    }

    public String toString() {
        return "VC:" + this.getName() + '(' + this.id + ')';
    }

    public VoiceChannelImpl setUserLimit(int userLimit) {
        this.userLimit = userLimit;
        return this;
    }

    public VoiceChannelImpl setBitrate(int bitrate) {
        this.bitrate = bitrate;
        return this;
    }

    public VoiceChannelImpl setRegion(String region) {
        this.region = region;
        return this;
    }

    public TLongObjectMap<Member> getConnectedMembersMap() {
        this.connectedMembers.transformValues(member -> {
            Member real = this.getGuild().getMemberById(member.getIdLong());
            return real != null ? real : member;
        });
        return this.connectedMembers;
    }
}

