/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.handle;

import github.scarsz.discordsrv.dependencies.jda.api.entities.Category;
import github.scarsz.discordsrv.dependencies.jda.api.entities.ChannelType;
import github.scarsz.discordsrv.dependencies.jda.api.entities.PrivateChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.StoreChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.VoiceChannel;
import github.scarsz.discordsrv.dependencies.jda.api.events.channel.category.CategoryDeleteEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.channel.store.StoreChannelDeleteEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.channel.text.TextChannelDeleteEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.channel.voice.VoiceChannelDeleteEvent;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.GuildImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.EventCache;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.SocketHandler;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.WebSocketClient;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.cache.SnowflakeCacheViewImpl;

public class ChannelDeleteHandler
extends SocketHandler {
    public ChannelDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        long guildId = 0L;
        if (type.isGuild()) {
            guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(guildId);
        long channelId = content.getLong("id");
        switch (type) {
            case STORE: {
                StoreChannel channel = (StoreChannel)this.getJDA().getStoreChannelsView().remove(channelId);
                if (channel == null || guild == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a store channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                guild.getStoreChannelView().remove(channelId);
                this.getJDA().handleEvent(new StoreChannelDeleteEvent(this.getJDA(), this.responseNumber, channel));
                break;
            }
            case TEXT: {
                TextChannel channel = (TextChannel)this.getJDA().getTextChannelsView().remove(channelId);
                if (channel == null || guild == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a text channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                guild.getTextChannelsView().remove(channel.getIdLong());
                this.getJDA().handleEvent(new TextChannelDeleteEvent(this.getJDA(), this.responseNumber, channel));
                break;
            }
            case STAGE: 
            case VOICE: {
                VoiceChannel channel = (VoiceChannel)this.getJDA().getVoiceChannelsView().remove(channelId);
                if (channel == null || guild == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a voice channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                guild.getVoiceChannelsView().remove(channel.getIdLong());
                this.getJDA().handleEvent(new VoiceChannelDeleteEvent(this.getJDA(), this.responseNumber, channel));
                break;
            }
            case CATEGORY: {
                Category category = (Category)this.getJDA().getCategoriesView().remove(channelId);
                if (category == null || guild == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a category channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                guild.getCategoriesView().remove(channelId);
                this.getJDA().handleEvent(new CategoryDeleteEvent(this.getJDA(), this.responseNumber, category));
                break;
            }
            case PRIVATE: {
                SnowflakeCacheViewImpl<PrivateChannel> privateView = this.getJDA().getPrivateChannelsView();
                PrivateChannel channel = (PrivateChannel)privateView.remove(channelId);
                if (channel != null) break;
                WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a private channel that is not yet cached. JSON: {}", (Object)content);
                return null;
            }
            case GROUP: {
                WebSocketClient.LOG.warn("Received a CHANNEL_DELETE for a channel of type GROUP which is not supported!");
                return null;
            }
            default: {
                WebSocketClient.LOG.debug("CHANNEL_DELETE provided an unknown channel type. JSON: {}", (Object)content);
            }
        }
        this.getJDA().getEventCache().clear(EventCache.Type.CHANNEL, channelId);
        return null;
    }
}

