/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.handle;

import github.scarsz.discordsrv.dependencies.jda.api.audio.hooks.ConnectionStatus;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Category;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.StoreChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.entities.VoiceChannel;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.GuildLeaveEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.GuildUnavailableEvent;
import github.scarsz.discordsrv.dependencies.jda.api.managers.AudioManager;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.GuildImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.EventCache;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.GuildSetupController;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.SocketHandler;
import github.scarsz.discordsrv.dependencies.jda.internal.managers.AudioManagerImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.WebSocketClient;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.UnlockHook;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.cache.AbstractCacheView;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.cache.SnowflakeCacheViewImpl;
import github.scarsz.discordsrv.dependencies.trove.set.TLongSet;

public class GuildDeleteHandler
extends SocketHandler {
    public GuildDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        long id = content.getLong("id");
        GuildSetupController setupController = this.getJDA().getGuildSetupController();
        boolean wasInit = setupController.onDelete(id, content);
        if (wasInit || setupController.isUnavailable(id)) {
            return null;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(id);
        boolean unavailable = content.getBoolean("unavailable");
        if (guild == null) {
            WebSocketClient.LOG.debug("Received GUILD_DELETE for a Guild that is not currently cached. ID: {} unavailable: {}", (Object)id, (Object)unavailable);
            return null;
        }
        if (setupController.isUnavailable(id) && unavailable) {
            return null;
        }
        SnowflakeCacheViewImpl<Guild> guildView = this.getJDA().getGuildsView();
        SnowflakeCacheViewImpl<StoreChannel> storeView = this.getJDA().getStoreChannelsView();
        SnowflakeCacheViewImpl<TextChannel> textView = this.getJDA().getTextChannelsView();
        SnowflakeCacheViewImpl<VoiceChannel> voiceView = this.getJDA().getVoiceChannelsView();
        SnowflakeCacheViewImpl<Category> categoryView = this.getJDA().getCategoriesView();
        guildView.remove(id);
        try (UnlockHook hook = storeView.writeLock();){
            guild.getStoreChannelCache().forEachUnordered(chan -> storeView.getMap().remove(chan.getIdLong()));
        }
        hook = textView.writeLock();
        try {
            guild.getTextChannelCache().forEachUnordered(chan -> textView.getMap().remove(chan.getIdLong()));
        }
        finally {
            if (hook != null) {
                hook.close();
            }
        }
        hook = voiceView.writeLock();
        try {
            guild.getVoiceChannelCache().forEachUnordered(chan -> voiceView.getMap().remove(chan.getIdLong()));
        }
        finally {
            if (hook != null) {
                hook.close();
            }
        }
        hook = categoryView.writeLock();
        try {
            guild.getCategoryCache().forEachUnordered(chan -> categoryView.getMap().remove(chan.getIdLong()));
        }
        finally {
            if (hook != null) {
                hook.close();
            }
        }
        this.getJDA().getClient().removeAudioConnection(id);
        AbstractCacheView<AudioManager> audioManagerView = this.getJDA().getAudioManagersView();
        AudioManagerImpl manager = (AudioManagerImpl)audioManagerView.get(id);
        if (manager != null) {
            manager.closeAudioConnection(ConnectionStatus.DISCONNECTED_REMOVED_FROM_GUILD);
        }
        audioManagerView.remove(id);
        TLongSet memberIds = guild.getMembersView().keySet();
        this.getJDA().getGuildCache().stream().map(GuildImpl.class::cast).forEach(g -> memberIds.removeAll(g.getMembersView().keySet()));
        SnowflakeCacheViewImpl<User> userView = this.getJDA().getUsersView();
        try (UnlockHook hook = userView.writeLock();){
            long selfId = this.getJDA().getSelfUser().getIdLong();
            memberIds.forEach(memberId -> {
                if (memberId == selfId) {
                    return true;
                }
                userView.remove(memberId);
                this.getJDA().getEventCache().clear(EventCache.Type.USER, memberId);
                return true;
            });
        }
        if (unavailable) {
            setupController.onUnavailable(id);
            guild.setAvailable(false);
            this.getJDA().handleEvent(new GuildUnavailableEvent(this.getJDA(), this.responseNumber, guild));
        } else {
            this.getJDA().handleEvent(new GuildLeaveEvent(this.getJDA(), this.responseNumber, guild));
        }
        this.getJDA().getEventCache().clear(EventCache.Type.GUILD, id);
        return null;
    }
}

