/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.handle;

import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.entities.VoiceChannel;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.GuildMemberLeaveEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.GuildMemberRemoveEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.voice.GuildVoiceLeaveEvent;
import github.scarsz.discordsrv.dependencies.jda.api.utils.cache.CacheView;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.GuildImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.GuildVoiceStateImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.MemberImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.MemberPresenceImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.UserImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.VoiceChannelImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.EventCache;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.SocketHandler;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.UnlockHook;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.cache.SnowflakeCacheViewImpl;

public class GuildMemberRemoveHandler
extends SocketHandler {
    public GuildMemberRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        long id = content.getLong("guild_id");
        boolean setup = this.getJDA().getGuildSetupController().onRemoveMember(id, content);
        if (setup) {
            return null;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildsView().get(id);
        if (guild == null) {
            return null;
        }
        long userId = content.getObject("user").getUnsignedLong("id");
        if (userId == this.getJDA().getSelfUser().getIdLong()) {
            return null;
        }
        guild.onMemberRemove();
        CacheView.SimpleCacheView<MemberPresenceImpl> presences = guild.getPresenceView();
        if (presences != null) {
            presences.remove(userId);
        }
        UserImpl user = this.api.getEntityBuilder().createUser(content.getObject("user"));
        MemberImpl member = (MemberImpl)guild.getMembersView().remove(userId);
        if (member == null) {
            guild.getVoiceChannelsView().forEachUnordered(channel -> {
                VoiceChannelImpl impl = (VoiceChannelImpl)channel;
                Member connected = impl.getConnectedMembersMap().remove(userId);
                if (connected != null) {
                    this.getJDA().handleEvent(new GuildVoiceLeaveEvent(this.getJDA(), this.responseNumber, connected, (VoiceChannel)channel));
                }
            });
            this.getJDA().handleEvent(new GuildMemberRemoveEvent(this.getJDA(), this.responseNumber, guild, user, null));
            return null;
        }
        GuildVoiceStateImpl voiceState = (GuildVoiceStateImpl)member.getVoiceState();
        if (voiceState != null && voiceState.inVoiceChannel()) {
            VoiceChannel channel2 = voiceState.getChannel();
            voiceState.setConnectedChannel(null);
            ((VoiceChannelImpl)channel2).getConnectedMembersMap().remove(userId);
            this.getJDA().handleEvent(new GuildVoiceLeaveEvent(this.getJDA(), this.responseNumber, member, channel2));
        }
        SnowflakeCacheViewImpl<User> userView = this.getJDA().getUsersView();
        try (UnlockHook hook = userView.writeLock();){
            if (userId != this.getJDA().getSelfUser().getIdLong() && this.getJDA().getGuildsView().stream().noneMatch(g -> g.getMemberById(userId) != null)) {
                userView.remove(userId);
                this.getJDA().getEventCache().clear(EventCache.Type.USER, userId);
            }
        }
        this.getJDA().handleEvent(new GuildMemberLeaveEvent((JDA)this.getJDA(), this.responseNumber, member));
        this.getJDA().handleEvent(new GuildMemberRemoveEvent(this.getJDA(), this.responseNumber, guild, user, member));
        return null;
    }
}

