/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.handle;

import github.scarsz.discordsrv.dependencies.jda.api.entities.Emote;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.events.role.RoleDeleteEvent;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.EmoteImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.GuildImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.MemberImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.EventCache;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.SocketHandler;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.WebSocketClient;

public class GuildRoleDeleteHandler
extends SocketHandler {
    public GuildRoleDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        long guildId = content.getLong("guild_id");
        if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(guildId);
        if (guild == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.GUILD, guildId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("GUILD_ROLE_DELETE was received for a Guild that is not yet cached: {}", (Object)content);
            return null;
        }
        long roleId = content.getLong("role_id");
        Role removedRole = (Role)guild.getRolesView().remove(roleId);
        if (removedRole == null) {
            WebSocketClient.LOG.debug("GUILD_ROLE_DELETE was received for a Role that is not yet cached: {}", (Object)content);
            return null;
        }
        guild.getMembersView().forEach(m -> {
            MemberImpl member = (MemberImpl)m;
            member.getRoleSet().remove(removedRole);
        });
        for (Emote emote : guild.getEmoteCache()) {
            EmoteImpl impl = (EmoteImpl)emote;
            if (!impl.canProvideRoles()) continue;
            impl.getRoleSet().remove(removedRole);
        }
        this.getJDA().handleEvent(new RoleDeleteEvent(this.getJDA(), this.responseNumber, removedRole));
        this.getJDA().getEventCache().clear(EventCache.Type.ROLE, roleId);
        return null;
    }
}

