/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.handle;

import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.ButtonClickEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.GenericInteractionCreateEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.SelectionMenuEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.SlashCommandEvent;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.InteractionType;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.Component;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.SocketHandler;
import github.scarsz.discordsrv.dependencies.jda.internal.interactions.ButtonInteractionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.interactions.CommandInteractionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.interactions.InteractionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.interactions.SelectionMenuInteractionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.WebSocketClient;

public class InteractionCreateHandler
extends SocketHandler {
    public InteractionCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        int type = content.getInt("type");
        if (content.getInt("version", 1) != 1) {
            WebSocketClient.LOG.debug("Received interaction with version {}. This version is currently unsupported by this version of JDA. Consider updating!", (Object)content.getInt("version", 1));
            return null;
        }
        long guildId = content.getUnsignedLong("guild_id", 0L);
        if (this.api.getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        if (guildId != 0L && this.api.getGuildById(guildId) == null) {
            return null;
        }
        switch (InteractionType.fromKey(type)) {
            case SLASH_COMMAND: {
                this.handleCommand(content);
                break;
            }
            case COMPONENT: {
                this.handleAction(content);
                break;
            }
            default: {
                this.api.handleEvent(new GenericInteractionCreateEvent(this.api, this.responseNumber, new InteractionImpl(this.api, content)));
            }
        }
        return null;
    }

    private void handleCommand(DataObject content) {
        this.api.handleEvent(new SlashCommandEvent((JDA)this.api, this.responseNumber, new CommandInteractionImpl(this.api, content)));
    }

    private void handleAction(DataObject content) {
        switch (Component.Type.fromKey(content.getObject("data").getInt("component_type"))) {
            case BUTTON: {
                this.api.handleEvent(new ButtonClickEvent((JDA)this.api, this.responseNumber, new ButtonInteractionImpl(this.api, content)));
                break;
            }
            case SELECTION_MENU: {
                this.api.handleEvent(new SelectionMenuEvent((JDA)this.api, this.responseNumber, new SelectionMenuInteractionImpl(this.api, content)));
            }
        }
    }
}

