/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.handle;

import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.StageInstance;
import github.scarsz.discordsrv.dependencies.jda.api.events.stage.StageInstanceCreateEvent;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.GuildImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.EventCache;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.SocketHandler;

public class StageInstanceCreateHandler
extends SocketHandler {
    public StageInstanceCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        long guildId = content.getUnsignedLong("guild_id", 0L);
        if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(guildId);
        if (guild == null) {
            EventCache.LOG.debug("Caching STAGE_INSTANCE_CREATE for uncached guild with id {}", (Object)guildId);
            this.getJDA().getEventCache().cache(EventCache.Type.GUILD, guildId, this.responseNumber, this.allContent, this::handle);
            return null;
        }
        StageInstance instance = this.getJDA().getEntityBuilder().createStageInstance(guild, content);
        if (instance != null) {
            this.getJDA().handleEvent(new StageInstanceCreateEvent((JDA)this.getJDA(), this.responseNumber, instance));
            guild.updateRequestToSpeak();
        }
        return null;
    }
}

