/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.handle;

import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.PrivateChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.events.user.UserTypingEvent;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.EntityBuilder;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.GuildImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.MemberImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.handle.SocketHandler;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class TypingStartHandler
extends SocketHandler {
    public TypingStartHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        GuildImpl guild = null;
        if (!content.isNull("guild_id")) {
            long guildId = content.getUnsignedLong("guild_id");
            guild = (GuildImpl)this.getJDA().getGuildById(guildId);
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
            if (guild == null) {
                return null;
            }
        }
        long channelId = content.getLong("channel_id");
        MessageChannel channel = (MessageChannel)this.getJDA().getTextChannelsView().get(channelId);
        if (channel == null) {
            channel = (MessageChannel)this.getJDA().getPrivateChannelsView().get(channelId);
        }
        if (channel == null) {
            return null;
        }
        long userId = content.getLong("user_id");
        MemberImpl member = null;
        User user = channel instanceof PrivateChannel ? ((PrivateChannel)channel).getUser() : (User)this.getJDA().getUsersView().get(userId);
        if (!content.isNull("member")) {
            EntityBuilder entityBuilder = this.getJDA().getEntityBuilder();
            member = entityBuilder.createMember(guild, content.getObject("member"));
            entityBuilder.updateMemberCache(member);
            user = member.getUser();
        }
        if (user == null) {
            return null;
        }
        OffsetDateTime timestamp = Instant.ofEpochSecond(content.getInt("timestamp")).atOffset(ZoneOffset.UTC);
        this.getJDA().handleEvent(new UserTypingEvent(this.getJDA(), this.responseNumber, user, channel, timestamp, member));
        return null;
    }
}

