/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.interactions;

import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageChannel;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.ComponentInteraction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.interactions.InteractionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction.interactions.UpdateInteractionActionImpl;
import javax.annotation.Nonnull;

public abstract class ComponentInteractionImpl
extends InteractionImpl
implements ComponentInteraction {
    protected final String customId;
    protected final Message message;
    protected final long messageId;

    public ComponentInteractionImpl(JDAImpl jda, DataObject data) {
        super(jda, data);
        this.customId = data.getObject("data").getString("custom_id");
        DataObject messageJson = data.getObject("message");
        this.messageId = messageJson.getUnsignedLong("id");
        this.message = messageJson.isNull("type") ? null : jda.getEntityBuilder().createMessage(messageJson);
    }

    @Override
    @Nonnull
    public MessageChannel getChannel() {
        return (MessageChannel)super.getChannel();
    }

    @Override
    @Nonnull
    public String getComponentId() {
        return this.customId;
    }

    @Override
    @Nonnull
    public Message getMessage() {
        return this.message;
    }

    @Override
    public long getMessageIdLong() {
        return this.messageId;
    }

    @Override
    @Nonnull
    public UpdateInteractionActionImpl deferEdit() {
        return new UpdateInteractionActionImpl(this.hook);
    }
}

