/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.interactions;

import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.Component;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.selections.SelectionMenu;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.selections.SelectionMenuInteraction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataArray;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.interactions.ComponentInteractionImpl;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SelectionMenuInteractionImpl
extends ComponentInteractionImpl
implements SelectionMenuInteraction {
    private final List<String> values;
    private final SelectionMenu menu;

    public SelectionMenuInteractionImpl(JDAImpl jda, DataObject data) {
        super(jda, data);
        this.values = Collections.unmodifiableList(data.getObject("data").getArray("values").stream(DataArray::getString).collect(Collectors.toList()));
        this.menu = this.message != null ? (SelectionMenu)this.message.getActionRows().stream().flatMap(row -> row.getComponents().stream()).filter(c -> c.getType() == Component.Type.SELECTION_MENU && this.customId.equals(c.getId())).findFirst().orElse(null) : null;
    }

    @Override
    @Nullable
    public SelectionMenu getComponent() {
        return this.menu;
    }

    @Override
    @Nonnull
    public Component.Type getComponentType() {
        return Component.Type.SELECTION_MENU;
    }

    @Override
    @Nonnull
    public List<String> getValues() {
        return this.values;
    }
}

