/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.managers;

import github.scarsz.discordsrv.dependencies.jda.api.entities.Icon;
import github.scarsz.discordsrv.dependencies.jda.api.entities.SelfUser;
import github.scarsz.discordsrv.dependencies.jda.api.managers.AccountManager;
import github.scarsz.discordsrv.dependencies.jda.api.requests.Request;
import github.scarsz.discordsrv.dependencies.jda.api.requests.Response;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.managers.ManagerBase;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.Route;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import github.scarsz.discordsrv.dependencies.okhttp3.RequestBody;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class AccountManagerImpl
extends ManagerBase<AccountManager>
implements AccountManager {
    protected final SelfUser selfUser;
    protected String name;
    protected Icon avatar;

    public AccountManagerImpl(SelfUser selfUser) {
        super(selfUser.getJDA(), Route.Self.MODIFY_SELF.compile(new String[0]));
        this.selfUser = selfUser;
    }

    @Override
    @Nonnull
    public SelfUser getSelfUser() {
        return this.selfUser;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public AccountManagerImpl reset(long fields) {
        super.reset(fields);
        if ((fields & 2L) == 2L) {
            this.avatar = null;
        }
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public AccountManagerImpl reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public AccountManagerImpl reset() {
        super.reset();
        this.avatar = null;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public AccountManagerImpl setName(@Nonnull String name) {
        Checks.notBlank(name, "Name");
        name = name.trim();
        Checks.notEmpty(name, "Name");
        Checks.notLonger(name, 32, "Name");
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public AccountManagerImpl setAvatar(Icon avatar) {
        this.avatar = avatar;
        this.set |= 2L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        DataObject body = DataObject.empty();
        body.put("username", this.getSelfUser().getName());
        body.put("avatar", this.getSelfUser().getAvatarId());
        if (this.shouldUpdate(1L)) {
            body.put("username", this.name);
        }
        if (this.shouldUpdate(2L)) {
            body.put("avatar", this.avatar == null ? null : this.avatar.getEncoding());
        }
        this.reset();
        return this.getRequestBody(body);
    }

    @Override
    protected void handleSuccess(Response response, Request<Void> request) {
        String newToken = response.getObject().getString("token").replace("Bot ", "");
        this.api.setToken(newToken);
        request.onSuccess(null);
    }
}

