/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.managers;

import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.VoiceChannel;
import github.scarsz.discordsrv.dependencies.jda.api.managers.DirectAudioController;
import github.scarsz.discordsrv.dependencies.jda.internal.JDAImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.WebSocketClient;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import javax.annotation.Nonnull;

public class DirectAudioControllerImpl
implements DirectAudioController {
    private final JDAImpl api;

    public DirectAudioControllerImpl(JDAImpl api) {
        this.api = api;
    }

    @Override
    @Nonnull
    public JDAImpl getJDA() {
        return this.api;
    }

    @Override
    public void connect(@Nonnull VoiceChannel channel) {
        Checks.notNull(channel, "Voice Channel");
        JDAImpl jda = this.getJDA();
        WebSocketClient client = jda.getClient();
        client.queueAudioConnect(channel);
    }

    @Override
    public void disconnect(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        JDAImpl jda = this.getJDA();
        WebSocketClient client = jda.getClient();
        client.queueAudioDisconnect(guild);
    }

    @Override
    public void reconnect(@Nonnull VoiceChannel channel) {
        Checks.notNull(channel, "Voice Channel");
        JDAImpl jda = this.getJDA();
        WebSocketClient client = jda.getClient();
        client.queueAudioReconnect(channel);
    }

    public void update(Guild guild, VoiceChannel channel) {
        Checks.notNull(guild, "Guild");
        JDAImpl jda = this.getJDA();
        WebSocketClient client = jda.getClient();
        client.updateAudioConnection(guild.getIdLong(), channel);
    }
}

