/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.managers;

import github.scarsz.discordsrv.dependencies.jda.api.entities.StageInstance;
import github.scarsz.discordsrv.dependencies.jda.api.managers.StageInstanceManager;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.managers.ManagerBase;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.Route;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import github.scarsz.discordsrv.dependencies.okhttp3.RequestBody;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StageInstanceManagerImpl
extends ManagerBase<StageInstanceManager>
implements StageInstanceManager {
    private final StageInstance instance;
    private String topic;
    private StageInstance.PrivacyLevel privacyLevel;

    public StageInstanceManagerImpl(StageInstance instance) {
        super(instance.getChannel().getJDA(), Route.StageInstances.UPDATE_INSTANCE.compile(instance.getChannel().getId()));
        this.instance = instance;
    }

    @Override
    @Nonnull
    public StageInstance getStageInstance() {
        return this.instance;
    }

    @Override
    @Nonnull
    public StageInstanceManager setTopic(@Nullable String topic) {
        if (topic != null) {
            topic = topic.trim();
            Checks.notLonger(topic, 120, "Topic");
            if (topic.isEmpty()) {
                topic = null;
            }
        }
        this.topic = topic;
        this.set |= 1L;
        return this;
    }

    @Override
    @Nonnull
    public StageInstanceManager setPrivacyLevel(@Nonnull StageInstance.PrivacyLevel level) {
        Checks.notNull((Object)level, "PrivacyLevel");
        Checks.check(level != StageInstance.PrivacyLevel.UNKNOWN, "PrivacyLevel must not be UNKNOWN!");
        this.privacyLevel = level;
        this.set |= 2L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        DataObject body = DataObject.empty();
        if (this.shouldUpdate(1L) && this.topic != null) {
            body.put("topic", this.topic);
        }
        if (this.shouldUpdate(2L)) {
            body.put("privacy_level", this.privacyLevel.getKey());
        }
        return this.getRequestBody(body);
    }
}

