/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.managers;

import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Icon;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Webhook;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.InsufficientPermissionException;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.MissingAccessException;
import github.scarsz.discordsrv.dependencies.jda.api.managers.WebhookManager;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.managers.ManagerBase;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.Route;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import github.scarsz.discordsrv.dependencies.okhttp3.RequestBody;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class WebhookManagerImpl
extends ManagerBase<WebhookManager>
implements WebhookManager {
    protected final Webhook webhook;
    protected String name;
    protected String channel;
    protected Icon avatar;

    public WebhookManagerImpl(Webhook webhook) {
        super(webhook.getJDA(), Route.Webhooks.MODIFY_WEBHOOK.compile(webhook.getId()));
        this.webhook = webhook;
        if (WebhookManagerImpl.isPermissionChecksEnabled()) {
            this.checkPermissions();
        }
    }

    @Override
    @Nonnull
    public Webhook getWebhook() {
        return this.webhook;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public WebhookManagerImpl reset(long fields) {
        super.reset(fields);
        if ((fields & 1L) == 1L) {
            this.name = null;
        }
        if ((fields & 2L) == 2L) {
            this.channel = null;
        }
        if ((fields & 4L) == 4L) {
            this.avatar = null;
        }
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public WebhookManagerImpl reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public WebhookManagerImpl reset() {
        super.reset();
        this.name = null;
        this.channel = null;
        this.avatar = null;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public WebhookManagerImpl setName(@Nonnull String name) {
        Checks.notBlank(name, "Name");
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public WebhookManagerImpl setAvatar(Icon icon) {
        this.avatar = icon;
        this.set |= 4L;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public WebhookManagerImpl setChannel(@Nonnull TextChannel channel) {
        Checks.notNull(channel, "Channel");
        Checks.check(channel.getGuild().equals(this.getGuild()), "Channel is not from the same guild");
        this.channel = channel.getId();
        this.set |= 2L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        DataObject data = DataObject.empty();
        if (this.shouldUpdate(1L)) {
            data.put("name", this.name);
        }
        if (this.shouldUpdate(2L)) {
            data.put("channel_id", this.channel);
        }
        if (this.shouldUpdate(4L)) {
            data.put("avatar", this.avatar == null ? null : this.avatar.getEncoding());
        }
        return this.getRequestBody(data);
    }

    @Override
    protected boolean checkPermissions() {
        TextChannel channel;
        Member selfMember = this.getGuild().getSelfMember();
        if (!selfMember.hasAccess(channel = this.getChannel())) {
            throw new MissingAccessException(channel, Permission.VIEW_CHANNEL);
        }
        if (!selfMember.hasPermission((GuildChannel)channel, Permission.MANAGE_WEBHOOKS)) {
            throw new InsufficientPermissionException(channel, Permission.MANAGE_WEBHOOKS);
        }
        return super.checkPermissions();
    }
}

