/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction;

import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.Command;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.build.CommandData;
import github.scarsz.discordsrv.dependencies.jda.api.requests.Request;
import github.scarsz.discordsrv.dependencies.jda.api.requests.Response;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.CommandListUpdateAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataArray;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.GuildImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.RestActionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.Route;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import github.scarsz.discordsrv.dependencies.okhttp3.RequestBody;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class CommandListUpdateActionImpl
extends RestActionImpl<List<Command>>
implements CommandListUpdateAction {
    private final List<CommandData> commands = new ArrayList<CommandData>();
    private final GuildImpl guild;

    public CommandListUpdateActionImpl(JDA api, GuildImpl guild, Route.CompiledRoute route) {
        super(api, route);
        this.guild = guild;
    }

    @Override
    @Nonnull
    public CommandListUpdateAction timeout(long timeout, @Nonnull TimeUnit unit) {
        return (CommandListUpdateAction)super.timeout(timeout, unit);
    }

    @Override
    @Nonnull
    public CommandListUpdateAction addCheck(@Nonnull BooleanSupplier checks) {
        return (CommandListUpdateAction)super.addCheck(checks);
    }

    @Override
    @Nonnull
    public CommandListUpdateAction setCheck(BooleanSupplier checks) {
        return (CommandListUpdateAction)super.setCheck(checks);
    }

    @Override
    @Nonnull
    public CommandListUpdateAction deadline(long timestamp) {
        return (CommandListUpdateAction)super.deadline(timestamp);
    }

    @Override
    @Nonnull
    public CommandListUpdateAction addCommands(@Nonnull Collection<? extends CommandData> commands) {
        Checks.noneNull(commands, "Command");
        Checks.check(this.commands.size() + commands.size() <= 100, "Cannot have more than 100 commands! Try using subcommands instead.");
        this.commands.addAll(commands);
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        DataArray json = DataArray.empty();
        json.addAll(this.commands);
        return this.getRequestBody(json);
    }

    @Override
    protected void handleSuccess(Response response, Request<List<Command>> request) {
        List commands = response.getArray().stream(DataArray::getObject).map((? super T obj) -> new Command(this.api, this.guild, (DataObject)obj)).collect(Collectors.toList());
        request.onSuccess(commands);
    }
}

