/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction;

import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.requests.Request;
import github.scarsz.discordsrv.dependencies.jda.api.requests.Response;
import github.scarsz.discordsrv.dependencies.jda.api.requests.RestAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.MiscUtil;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.RestActionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.Route;
import github.scarsz.discordsrv.dependencies.okhttp3.RequestBody;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class TriggerRestAction<T>
extends RestActionImpl<T> {
    private final ReentrantLock mutex = new ReentrantLock();
    private final List<Runnable> callbacks = new LinkedList<Runnable>();
    private volatile boolean isReady;
    private volatile Throwable exception;

    public TriggerRestAction(JDA api, Route.CompiledRoute route) {
        super(api, route);
    }

    public TriggerRestAction(JDA api, Route.CompiledRoute route, DataObject data) {
        super(api, route, data);
    }

    public TriggerRestAction(JDA api, Route.CompiledRoute route, RequestBody data) {
        super(api, route, data);
    }

    public TriggerRestAction(JDA api, Route.CompiledRoute route, BiFunction<Response, Request<T>, T> handler) {
        super(api, route, handler);
    }

    public TriggerRestAction(JDA api, Route.CompiledRoute route, DataObject data, BiFunction<Response, Request<T>, T> handler) {
        super(api, route, data, handler);
    }

    public TriggerRestAction(JDA api, Route.CompiledRoute route, RequestBody data, BiFunction<Response, Request<T>, T> handler) {
        super(api, route, data, handler);
    }

    public void run() {
        MiscUtil.locked(this.mutex, () -> {
            this.isReady = true;
            this.callbacks.forEach(Runnable::run);
        });
    }

    public void fail(Throwable throwable) {
        MiscUtil.locked(this.mutex, () -> {
            this.exception = throwable;
            this.callbacks.forEach(Runnable::run);
        });
    }

    public void onReady(Runnable callback) {
        MiscUtil.locked(this.mutex, () -> {
            if (this.isReady || this.exception != null) {
                callback.run();
            } else {
                this.callbacks.add(callback);
            }
        });
    }

    @Override
    public void queue(Consumer<? super T> success, Consumer<? super Throwable> failure) {
        if (this.isReady) {
            super.queue(success, failure);
        } else {
            this.onReady(() -> {
                if (this.exception != null) {
                    if (failure != null) {
                        failure.accept(this.exception);
                    } else {
                        RestAction.getDefaultFailure().accept(this.exception);
                    }
                } else {
                    super.queue(success, failure);
                }
            });
        }
    }

    @Override
    @Nonnull
    public CompletableFuture<T> submit(boolean shouldQueue) {
        if (this.isReady) {
            return super.submit(shouldQueue);
        }
        CompletableFuture future = new CompletableFuture();
        this.onReady(() -> {
            if (this.exception != null) {
                future.completeExceptionally(this.exception);
                return;
            }
            CompletableFuture handle = super.submit(shouldQueue);
            handle.whenComplete((success, error) -> {
                if (error != null) {
                    future.completeExceptionally((Throwable)error);
                } else {
                    future.complete(success);
                }
            });
            future.whenComplete((r, e) -> {
                if (future.isCancelled()) {
                    handle.cancel(false);
                }
            });
        });
        return future;
    }
}

