/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction;

import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Icon;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Webhook;
import github.scarsz.discordsrv.dependencies.jda.api.requests.Request;
import github.scarsz.discordsrv.dependencies.jda.api.requests.Response;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.WebhookAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataObject;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.WebhookImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.Route;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction.AuditableRestActionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import github.scarsz.discordsrv.dependencies.okhttp3.RequestBody;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class WebhookActionImpl
extends AuditableRestActionImpl<Webhook>
implements WebhookAction {
    protected final TextChannel channel;
    protected String name;
    protected Icon avatar = null;

    public WebhookActionImpl(JDA api, TextChannel channel, String name) {
        super(api, Route.Channels.CREATE_WEBHOOK.compile(channel.getId()));
        this.channel = channel;
        this.name = name;
    }

    @Override
    @Nonnull
    public WebhookActionImpl setCheck(BooleanSupplier checks) {
        return (WebhookActionImpl)super.setCheck(checks);
    }

    @Override
    @Nonnull
    public WebhookActionImpl timeout(long timeout, @Nonnull TimeUnit unit) {
        return (WebhookActionImpl)super.timeout(timeout, unit);
    }

    @Override
    @Nonnull
    public WebhookActionImpl deadline(long timestamp) {
        return (WebhookActionImpl)super.deadline(timestamp);
    }

    @Override
    @Nonnull
    public TextChannel getChannel() {
        return this.channel;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public WebhookActionImpl setName(@Nonnull String name) {
        Checks.notEmpty(name, "Name");
        Checks.notLonger(name, 100, "Name");
        this.name = name;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public WebhookActionImpl setAvatar(Icon icon) {
        this.avatar = icon;
        return this;
    }

    @Override
    public RequestBody finalizeData() {
        DataObject object = DataObject.empty();
        object.put("name", this.name);
        object.put("avatar", this.avatar != null ? this.avatar.getEncoding() : null);
        return this.getRequestBody(object);
    }

    @Override
    protected void handleSuccess(Response response, Request<Webhook> request) {
        DataObject json = response.getObject();
        WebhookImpl webhook = this.api.getEntityBuilder().createWebhook(json);
        if (webhook == null) {
            return;
        }
        request.onSuccess(webhook);
    }
}

