/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction.order;

import github.scarsz.discordsrv.dependencies.jda.api.entities.Category;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildChannel;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.order.CategoryOrderAction;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction.order.ChannelOrderActionImpl;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.Checks;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class CategoryOrderActionImpl
extends ChannelOrderActionImpl
implements CategoryOrderAction {
    protected final Category category;

    public CategoryOrderActionImpl(Category category, int bucket) {
        super(category.getGuild(), bucket, CategoryOrderActionImpl.getChannelsOfType(category, bucket));
        this.category = category;
    }

    @Override
    @Nonnull
    public Category getCategory() {
        return this.category;
    }

    @Override
    protected void validateInput(GuildChannel entity) {
        Checks.notNull(entity, "Provided channel");
        Checks.check(this.getCategory().equals(entity.getParent()), "Provided channel's Category is not this Category!");
        Checks.check(this.orderList.contains(entity), "Provided channel is not in the list of orderable channels!");
    }

    @Nonnull
    private static Collection<GuildChannel> getChannelsOfType(Category category, int bucket) {
        Checks.notNull(category, "Category");
        return ChannelOrderActionImpl.getChannelsOfType(category.getGuild(), bucket).stream().filter(it -> category.equals(it.getParent())).sorted().collect(Collectors.toList());
    }
}

