/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction.pagination;

import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.ChannelType;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.InsufficientPermissionException;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.MissingAccessException;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.ParsingException;
import github.scarsz.discordsrv.dependencies.jda.api.requests.Request;
import github.scarsz.discordsrv.dependencies.jda.api.requests.Response;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.pagination.MessagePaginationAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.data.DataArray;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.EntityBuilder;
import github.scarsz.discordsrv.dependencies.jda.internal.entities.ReceivedMessage;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.Route;
import github.scarsz.discordsrv.dependencies.jda.internal.requests.restaction.pagination.PaginationActionImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class MessagePaginationActionImpl
extends PaginationActionImpl<Message, MessagePaginationAction>
implements MessagePaginationAction {
    private final MessageChannel channel;

    public MessagePaginationActionImpl(MessageChannel channel) {
        super(channel.getJDA(), Route.Messages.GET_MESSAGE_HISTORY.compile(channel.getId()), 1, 100, 100);
        if (channel.getType() == ChannelType.TEXT) {
            TextChannel textChannel = (TextChannel)channel;
            Member selfMember = textChannel.getGuild().getSelfMember();
            if (!selfMember.hasAccess(textChannel)) {
                throw new MissingAccessException(textChannel, Permission.VIEW_CHANNEL);
            }
            if (!selfMember.hasPermission((GuildChannel)textChannel, Permission.MESSAGE_HISTORY)) {
                throw new InsufficientPermissionException(textChannel, Permission.MESSAGE_HISTORY);
            }
        }
        this.channel = channel;
    }

    @Override
    @Nonnull
    public MessageChannel getChannel() {
        return this.channel;
    }

    @Override
    protected Route.CompiledRoute finalizeRoute() {
        Route.CompiledRoute route = super.finalizeRoute();
        String limit = String.valueOf(this.getLimit());
        long last = this.lastKey;
        route = route.withQueryParams("limit", limit);
        if (last != 0L) {
            route = route.withQueryParams("before", Long.toUnsignedString(last));
        }
        return route;
    }

    @Override
    protected void handleSuccess(Response response, Request<List<Message>> request) {
        DataArray array = response.getArray();
        ArrayList<ReceivedMessage> messages = new ArrayList<ReceivedMessage>(array.length());
        EntityBuilder builder = this.api.getEntityBuilder();
        for (int i = 0; i < array.length(); ++i) {
            try {
                ReceivedMessage msg = builder.createMessage(array.getObject(i), this.channel, false);
                messages.add(msg);
                if (this.useCache) {
                    this.cached.add(msg);
                }
                this.last = msg;
                this.lastKey = ((Message)this.last).getIdLong();
                continue;
            }
            catch (ParsingException | NullPointerException e) {
                LOG.warn("Encountered an exception in MessagePagination", e);
                continue;
            }
            catch (IllegalArgumentException e) {
                if ("UNKNOWN_MESSAGE_TYPE".equals(e.getMessage())) {
                    LOG.warn("Skipping unknown message type during pagination", e);
                    continue;
                }
                LOG.warn("Unexpected issue trying to parse message during pagination", e);
            }
        }
        request.onSuccess(messages);
    }

    @Override
    protected long getKey(Message it) {
        return it.getIdLong();
    }
}

