/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jda.internal.utils;

import github.scarsz.discordsrv.dependencies.okhttp3.MediaType;
import github.scarsz.discordsrv.dependencies.okhttp3.RequestBody;
import github.scarsz.discordsrv.dependencies.okio.BufferedSink;
import github.scarsz.discordsrv.dependencies.okio.BufferedSource;
import github.scarsz.discordsrv.dependencies.okio.Okio;
import github.scarsz.discordsrv.dependencies.okio.Source;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BufferedRequestBody
extends RequestBody {
    private final Source source;
    private final MediaType type;
    private byte[] data;

    public BufferedRequestBody(Source source, MediaType type) {
        this.source = source;
        this.type = type;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.type;
    }

    @Override
    public void writeTo(@Nonnull BufferedSink sink) throws IOException {
        if (this.data != null) {
            sink.write(this.data);
            return;
        }
        try (BufferedSource s = Okio.buffer(this.source);){
            this.data = s.readByteArray();
            sink.write(this.data);
        }
    }
}

