/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.mcdiscordreserializer.rules;

import github.scarsz.discordsrv.dependencies.simpleast.core.TextStyle;
import github.scarsz.discordsrv.dependencies.simpleast.core.node.Node;
import github.scarsz.discordsrv.dependencies.simpleast.core.node.StyleNode;
import github.scarsz.discordsrv.dependencies.simpleast.core.node.TextNode;
import github.scarsz.discordsrv.dependencies.simpleast.core.parser.ParseSpec;
import github.scarsz.discordsrv.dependencies.simpleast.core.parser.Parser;
import github.scarsz.discordsrv.dependencies.simpleast.core.parser.Rule;
import github.scarsz.discordsrv.dependencies.simpleast.core.simple.SimpleMarkdownRules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DiscordMarkdownRules {
    private static final Pattern PATTERN_EMOTE_MENTION = Pattern.compile("^<a?:(\\w+):(\\d+)>");
    private static final Pattern PATTERN_CHANNEL_MENTION = Pattern.compile("^<#(\\d+)>");
    private static final Pattern PATTERN_USER_MENTION = Pattern.compile("^<@!?(\\d+)>");
    private static final Pattern PATTERN_ROLE_MENTION = Pattern.compile("^<@&(\\d+)>");
    private static final Pattern PATTERN_SPOILER = Pattern.compile("^\\|\\|([\\s\\S]+?)\\|\\|");
    private static final Pattern PATTERN_CODE_STRING = Pattern.compile("^`(.+?)`");
    private static final Pattern PATTERN_QUOTE = Pattern.compile("^> (.+(?:\\n> .+)*)", 32);
    private static final Pattern PATTERN_CODE_BLOCK = Pattern.compile("^```(?:(\\S+?)[\\n ])?\\n*(?:(.+?))\\n*```");
    private static final Pattern PATTERN_TEXT = Pattern.compile("^[\\s\\S]+?(?=[^0-9A-Za-z\\s\\u00c0-\\uffff>]|\\n| {2,}\\n|\\w+:\\S|$)");

    private DiscordMarkdownRules() {
    }

    public static <R, S> Rule<R, Node<R>, S> createEmoteMentionRule() {
        return new Rule<R, Node<R>, S>(PATTERN_EMOTE_MENTION){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                HashMap<String, String> extra = new HashMap<String, String>();
                extra.put("name", matcher.group(1));
                extra.put("id", matcher.group(2));
                return ParseSpec.createTerminal(new StyleNode(new ArrayList<TextStyle>(Collections.singletonList(new TextStyle(TextStyle.Type.MENTION_EMOJI, extra)))), state);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createChannelMentionRule() {
        return DiscordMarkdownRules.createSimpleMentionRule(PATTERN_CHANNEL_MENTION, TextStyle.Type.MENTION_CHANNEL);
    }

    public static <R, S> Rule<R, Node<R>, S> createUserMentionRule() {
        return DiscordMarkdownRules.createSimpleMentionRule(PATTERN_USER_MENTION, TextStyle.Type.MENTION_USER);
    }

    public static <R, S> Rule<R, Node<R>, S> createRoleMentionRule() {
        return DiscordMarkdownRules.createSimpleMentionRule(PATTERN_ROLE_MENTION, TextStyle.Type.MENTION_ROLE);
    }

    public static <R, S> Rule<R, Node<R>, S> createSpoilerRule() {
        return new Rule<R, Node<R>, S>(PATTERN_SPOILER){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                HashMap<String, String> extra = new HashMap<String, String>();
                extra.put("content", matcher.group(1));
                return ParseSpec.createTerminal(new StyleNode(new ArrayList<TextStyle>(Collections.singletonList(new TextStyle(TextStyle.Type.SPOILER, extra)))), state);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createCodeStringRule() {
        return new Rule<R, Node<R>, S>(PATTERN_CODE_STRING){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                String content = matcher.group();
                return ParseSpec.createTerminal(StyleNode.Companion.createWithText(content.substring(1, content.length() - 1), new ArrayList<TextStyle>(Collections.singletonList(new TextStyle(TextStyle.Type.CODE_STRING)))), state);
            }
        };
    }

    private static <R, S> Rule<R, Node<R>, S> createSimpleMentionRule(Pattern pattern, final TextStyle.Type styleType) {
        return new Rule<R, Node<R>, S>(pattern){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                HashMap<String, String> extra = new HashMap<String, String>();
                extra.put("id", matcher.group(1));
                TextStyle textStyle = new TextStyle(styleType, extra);
                return ParseSpec.createTerminal(new StyleNode(new ArrayList<TextStyle>(Collections.singletonList(textStyle))), state);
            }
        };
    }

    public static <R> Rule<R, Node<R>, Object> createQuoteRule() {
        return new Rule<R, Node<R>, Object>(PATTERN_QUOTE){

            @Override
            public Matcher match(CharSequence inspectionSource, String lastCapture, Object state) {
                if (state instanceof QuoteState && ((QuoteState)state).isInQuote) {
                    return null;
                }
                return super.match(inspectionSource, lastCapture, state);
            }

            @Override
            public ParseSpec<R, Node<R>, Object> parse(Matcher matcher, Parser parser, Object state) {
                QuoteState newState = state instanceof QuoteState ? ((QuoteState)state).newQuoteState(true) : new QuoteState(true);
                HashMap<String, String> extra = new HashMap<String, String>();
                extra.put("content", matcher.group(1).trim().replace("\n> ", "\n"));
                return ParseSpec.createNonterminal(new StyleNode(Collections.singletonList(new TextStyle(TextStyle.Type.QUOTE, extra))), newState, matcher.start(1), matcher.end(1));
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createCodeBlockRule() {
        return new Rule<R, Node<R>, S>(PATTERN_CODE_BLOCK){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                HashMap<String, String> extra = new HashMap<String, String>();
                extra.put("language", matcher.group(1));
                return ParseSpec.createTerminal(StyleNode.Companion.createWithText(matcher.group(2), new ArrayList<TextStyle>(Collections.singletonList(new TextStyle(TextStyle.Type.CODE_BLOCK, extra)))), state);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createSpecialTextRule() {
        return new Rule<R, Node<R>, S>(PATTERN_TEXT){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                return ParseSpec.createTerminal(new TextNode(matcher.group()), state);
            }
        };
    }

    public static <R, S> List<Rule<R, Node<R>, S>> createMentionRules() {
        ArrayList<Rule<R, Node<R>, S>> rules = new ArrayList<Rule<R, Node<R>, S>>();
        rules.add(DiscordMarkdownRules.createEmoteMentionRule());
        rules.add(DiscordMarkdownRules.createChannelMentionRule());
        rules.add(DiscordMarkdownRules.createUserMentionRule());
        rules.add(DiscordMarkdownRules.createRoleMentionRule());
        return rules;
    }

    public static <R> List<Rule<R, Node<R>, Object>> createStyleRules() {
        ArrayList<Rule<R, Node<R>, Object>> rules = new ArrayList<Rule<R, Node<R>, Object>>();
        rules.add(DiscordMarkdownRules.createQuoteRule());
        rules.add(DiscordMarkdownRules.createSpoilerRule());
        rules.add(DiscordMarkdownRules.createCodeBlockRule());
        rules.add(DiscordMarkdownRules.createCodeStringRule());
        return rules;
    }

    public static <R> List<Rule<R, Node<R>, Object>> createDiscordMarkdownRules() {
        ArrayList<Rule<R, Node<R>, Object>> rules = new ArrayList<Rule<R, Node<R>, Object>>();
        rules.addAll(DiscordMarkdownRules.createStyleRules());
        rules.addAll(DiscordMarkdownRules.createMentionRules());
        return rules;
    }

    public static <R> List<Rule<R, Node<R>, Object>> createAllRulesForDiscord(boolean includeText) {
        ArrayList<Rule<R, Node<R>, Object>> rules = new ArrayList<Rule<R, Node<R>, Object>>();
        rules.addAll(SimpleMarkdownRules.createSimpleMarkdownRules(false));
        rules.addAll(DiscordMarkdownRules.createDiscordMarkdownRules());
        if (includeText) {
            rules.add(DiscordMarkdownRules.createSpecialTextRule());
        }
        return rules;
    }

    public static class QuoteState {
        private boolean isInQuote;

        public QuoteState(boolean isInQuote) {
            this.isInQuote = isInQuote;
        }

        public QuoteState newQuoteState(boolean isInQuote) {
            this.isInQuote = isInQuote;
            return this;
        }
    }
}

