/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.minidns.cache;

import github.scarsz.discordsrv.dependencies.minidns.DnsCache;
import github.scarsz.discordsrv.dependencies.minidns.dnsmessage.DnsMessage;
import github.scarsz.discordsrv.dependencies.minidns.dnsname.DnsName;
import github.scarsz.discordsrv.dependencies.minidns.dnsqueryresult.CachedDnsQueryResult;
import github.scarsz.discordsrv.dependencies.minidns.dnsqueryresult.DirectCachedDnsQueryResult;
import github.scarsz.discordsrv.dependencies.minidns.dnsqueryresult.DnsQueryResult;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache
extends DnsCache {
    protected long missCount = 0L;
    protected long expireCount = 0L;
    protected long hitCount = 0L;
    protected int capacity;
    protected long maxTTL;
    protected LinkedHashMap<DnsMessage, CachedDnsQueryResult> backend;

    public LruCache(final int capacity, long maxTTL) {
        this.capacity = capacity;
        this.maxTTL = maxTTL;
        this.backend = new LinkedHashMap<DnsMessage, CachedDnsQueryResult>(Math.min(capacity + (capacity + 3) / 4 + 2, 11), 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<DnsMessage, CachedDnsQueryResult> eldest) {
                return this.size() > capacity;
            }
        };
    }

    public LruCache(int capacity) {
        this(capacity, Long.MAX_VALUE);
    }

    public LruCache() {
        this(512);
    }

    @Override
    protected synchronized void putNormalized(DnsMessage q, DnsQueryResult result) {
        if (result.response.receiveTimestamp <= 0L) {
            return;
        }
        this.backend.put(q, new DirectCachedDnsQueryResult(q, result));
    }

    @Override
    protected synchronized CachedDnsQueryResult getNormalized(DnsMessage q) {
        long now;
        CachedDnsQueryResult result = this.backend.get(q);
        if (result == null) {
            ++this.missCount;
            return null;
        }
        DnsMessage message = result.response;
        long answersMinTtl = message.getAnswersMinTtl();
        long ttl = Math.min(answersMinTtl, this.maxTTL);
        long expiryDate = message.receiveTimestamp + ttl * 1000L;
        if (expiryDate < (now = System.currentTimeMillis())) {
            ++this.missCount;
            ++this.expireCount;
            this.backend.remove(q);
            return null;
        }
        ++this.hitCount;
        return result;
    }

    public synchronized void clear() {
        this.backend.clear();
        this.missCount = 0L;
        this.hitCount = 0L;
        this.expireCount = 0L;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public long getExpireCount() {
        return this.expireCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public String toString() {
        return "LRUCache{usage=" + this.backend.size() + "/" + this.capacity + ", hits=" + this.hitCount + ", misses=" + this.missCount + ", expires=" + this.expireCount + "}";
    }

    @Override
    public void offer(DnsMessage query, DnsQueryResult result, DnsName knownAuthoritativeZone) {
    }
}

