/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.minidns.constants;

import java.util.HashMap;
import java.util.Map;

public final class DnssecConstants {
    private static final Map<Byte, SignatureAlgorithm> SIGNATURE_ALGORITHM_LUT = new HashMap<Byte, SignatureAlgorithm>();
    private static final Map<Byte, DigestAlgorithm> DELEGATION_DIGEST_LUT = new HashMap<Byte, DigestAlgorithm>();

    private DnssecConstants() {
    }

    public static enum DigestAlgorithm {
        SHA1(1, "SHA-1"),
        SHA256(2, "SHA-256"),
        GOST(3, "GOST R 34.11-94"),
        SHA384(4, "SHA-384");

        public final byte value;
        public final String description;

        private DigestAlgorithm(int value, String description) {
            if (value < 0 || value > 255) {
                throw new IllegalArgumentException();
            }
            this.value = (byte)value;
            this.description = description;
            DELEGATION_DIGEST_LUT.put(this.value, this);
        }

        public static DigestAlgorithm forByte(byte b) {
            return (DigestAlgorithm)((Object)DELEGATION_DIGEST_LUT.get(b));
        }
    }

    public static enum SignatureAlgorithm {
        RSAMD5(1, "RSA/MD5"),
        DH(2, "Diffie-Hellman"),
        DSA(3, "DSA/SHA1"),
        RSASHA1(5, "RSA/SHA-1"),
        DSA_NSEC3_SHA1(6, "DSA_NSEC3-SHA1"),
        RSASHA1_NSEC3_SHA1(7, "RSASHA1-NSEC3-SHA1"),
        RSASHA256(8, "RSA/SHA-256"),
        RSASHA512(10, "RSA/SHA-512"),
        ECC_GOST(12, "GOST R 34.10-2001"),
        ECDSAP256SHA256(13, "ECDSA Curve P-256 with SHA-256"),
        ECDSAP384SHA384(14, "ECDSA Curve P-384 with SHA-384"),
        INDIRECT(252, "Reserved for Indirect Keys"),
        PRIVATEDNS(253, "private algorithm"),
        PRIVATEOID(254, "private algorithm oid");

        public final byte number;
        public final String description;

        private SignatureAlgorithm(int number, String description) {
            if (number < 0 || number > 255) {
                throw new IllegalArgumentException();
            }
            this.number = (byte)number;
            this.description = description;
            SIGNATURE_ALGORITHM_LUT.put(this.number, this);
        }

        public static SignatureAlgorithm forByte(byte b) {
            return (SignatureAlgorithm)((Object)SIGNATURE_ALGORITHM_LUT.get(b));
        }
    }
}

