/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.minidns.dnslabel;

import github.scarsz.discordsrv.dependencies.minidns.dnslabel.LdhLabel;
import github.scarsz.discordsrv.dependencies.minidns.dnslabel.NonLdhLabel;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public abstract class DnsLabel
implements CharSequence,
Comparable<DnsLabel> {
    public static final int MAX_LABEL_LENGTH_IN_OCTETS = 63;
    public static final DnsLabel WILDCARD_LABEL = DnsLabel.from("*");
    public static boolean VALIDATE = true;
    public final String label;
    private transient String internationalizedRepresentation;
    private transient DnsLabel lowercasedVariant;
    private transient byte[] byteCache;

    protected DnsLabel(String label) {
        this.label = label;
        if (!VALIDATE) {
            return;
        }
        this.setBytesIfRequired();
        if (this.byteCache.length > 63) {
            throw new LabelToLongException(label);
        }
    }

    public final String getInternationalizedRepresentation() {
        if (this.internationalizedRepresentation == null) {
            this.internationalizedRepresentation = this.getInternationalizedRepresentationInternal();
        }
        return this.internationalizedRepresentation;
    }

    protected String getInternationalizedRepresentationInternal() {
        return this.label;
    }

    public final String getLabelType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final int length() {
        return this.label.length();
    }

    @Override
    public final char charAt(int index) {
        return this.label.charAt(index);
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return this.label.subSequence(start, end);
    }

    @Override
    public final String toString() {
        return this.label;
    }

    public final boolean equals(Object other) {
        if (!(other instanceof DnsLabel)) {
            return false;
        }
        DnsLabel otherDnsLabel = (DnsLabel)other;
        return this.label.equals(otherDnsLabel.label);
    }

    public final int hashCode() {
        return this.label.hashCode();
    }

    public final DnsLabel asLowercaseVariant() {
        if (this.lowercasedVariant == null) {
            String lowercaseLabel = this.label.toLowerCase(Locale.US);
            this.lowercasedVariant = DnsLabel.from(lowercaseLabel);
        }
        return this.lowercasedVariant;
    }

    private void setBytesIfRequired() {
        if (this.byteCache == null) {
            this.byteCache = this.label.getBytes(StandardCharsets.US_ASCII);
        }
    }

    public final void writeToBoas(ByteArrayOutputStream byteArrayOutputStream) {
        this.setBytesIfRequired();
        byteArrayOutputStream.write(this.byteCache.length);
        byteArrayOutputStream.write(this.byteCache, 0, this.byteCache.length);
    }

    @Override
    public final int compareTo(DnsLabel other) {
        String myCanonical = this.asLowercaseVariant().label;
        String otherCanonical = other.asLowercaseVariant().label;
        return myCanonical.compareTo(otherCanonical);
    }

    public static DnsLabel from(String label) {
        if (label == null || label.isEmpty()) {
            throw new IllegalArgumentException("Label is null or empty");
        }
        if (LdhLabel.isLdhLabel(label)) {
            return LdhLabel.fromInternal(label);
        }
        return NonLdhLabel.fromInternal(label);
    }

    public static DnsLabel[] from(String[] labels) {
        DnsLabel[] res = new DnsLabel[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            res[i] = DnsLabel.from(labels[i]);
        }
        return res;
    }

    public static boolean isIdnAcePrefixed(String string) {
        return string.toLowerCase(Locale.US).startsWith("xn--");
    }

    public static class LabelToLongException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        public final String label;

        LabelToLongException(String label) {
            this.label = label;
        }
    }
}

