/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.minidns.dnslabel;

import github.scarsz.discordsrv.dependencies.minidns.dnslabel.DnsLabel;
import github.scarsz.discordsrv.dependencies.minidns.dnslabel.LeadingOrTrailingHyphenLabel;
import github.scarsz.discordsrv.dependencies.minidns.dnslabel.NonReservedLdhLabel;
import github.scarsz.discordsrv.dependencies.minidns.dnslabel.ReservedLdhLabel;
import github.scarsz.discordsrv.dependencies.minidns.dnslabel.XnLabel;

public abstract class LdhLabel
extends DnsLabel {
    protected LdhLabel(String label) {
        super(label);
    }

    public static boolean isLdhLabel(String label) {
        if (label.isEmpty()) {
            return false;
        }
        if (LeadingOrTrailingHyphenLabel.isLeadingOrTrailingHypenLabelInternal(label)) {
            return false;
        }
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-') continue;
            return false;
        }
        return true;
    }

    protected static LdhLabel fromInternal(String label) {
        assert (LdhLabel.isLdhLabel(label));
        if (ReservedLdhLabel.isReservedLdhLabel(label)) {
            if (XnLabel.isXnLabelInternal(label)) {
                return XnLabel.fromInternal(label);
            }
            return new ReservedLdhLabel(label);
        }
        return new NonReservedLdhLabel(label);
    }
}

