/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.minidns.dnslabel;

import github.scarsz.discordsrv.dependencies.minidns.dnslabel.ALabel;
import github.scarsz.discordsrv.dependencies.minidns.dnslabel.FakeALabel;
import github.scarsz.discordsrv.dependencies.minidns.dnslabel.LdhLabel;
import github.scarsz.discordsrv.dependencies.minidns.dnslabel.ReservedLdhLabel;
import github.scarsz.discordsrv.dependencies.minidns.idna.MiniDnsIdna;
import java.util.Locale;

public abstract class XnLabel
extends ReservedLdhLabel {
    protected XnLabel(String label) {
        super(label);
    }

    protected static LdhLabel fromInternal(String label) {
        assert (XnLabel.isIdnAcePrefixed(label));
        String uLabel = MiniDnsIdna.toUnicode(label);
        if (label.equals(uLabel)) {
            return new FakeALabel(label);
        }
        return new ALabel(label);
    }

    public static boolean isXnLabel(String label) {
        if (!XnLabel.isLdhLabel(label)) {
            return false;
        }
        return XnLabel.isXnLabelInternal(label);
    }

    static boolean isXnLabelInternal(String label) {
        return label.substring(0, 2).toLowerCase(Locale.US).equals("xn");
    }
}

