/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.minidns.record;

import github.scarsz.discordsrv.dependencies.minidns.record.Record;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public abstract class Data {
    private byte[] bytes;
    private transient Integer hashCodeCache;

    public abstract Record.TYPE getType();

    protected abstract void serialize(DataOutputStream var1) throws IOException;

    private void setBytes() {
        if (this.bytes != null) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.serialize(dos);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.bytes = baos.toByteArray();
    }

    public final int length() {
        this.setBytes();
        return this.bytes.length;
    }

    public final void toOutputStream(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.toOutputStream(dataOutputStream);
    }

    public final void toOutputStream(DataOutputStream dos) throws IOException {
        this.setBytes();
        dos.write(this.bytes);
    }

    public final byte[] toByteArray() {
        this.setBytes();
        return (byte[])this.bytes.clone();
    }

    public final int hashCode() {
        if (this.hashCodeCache == null) {
            this.setBytes();
            this.hashCodeCache = Arrays.hashCode(this.bytes);
        }
        return this.hashCodeCache;
    }

    public final boolean equals(Object other) {
        if (!(other instanceof Data)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Data otherData = (Data)other;
        otherData.setBytes();
        this.setBytes();
        return Arrays.equals(this.bytes, otherData.bytes);
    }
}

