/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.minidns.record;

import github.scarsz.discordsrv.dependencies.minidns.record.A;
import github.scarsz.discordsrv.dependencies.minidns.record.AAAA;
import github.scarsz.discordsrv.dependencies.minidns.record.Data;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class InternetAddressRR<IA extends InetAddress>
extends Data {
    protected final byte[] ip;
    private transient IA inetAddress;

    protected InternetAddressRR(byte[] ip) {
        this.ip = ip;
    }

    protected InternetAddressRR(IA inetAddress) {
        this(((InetAddress)inetAddress).getAddress());
        this.inetAddress = inetAddress;
    }

    @Override
    public final void serialize(DataOutputStream dos) throws IOException {
        dos.write(this.ip);
    }

    public final byte[] getIp() {
        return (byte[])this.ip.clone();
    }

    public final IA getInetAddress() {
        if (this.inetAddress == null) {
            try {
                this.inetAddress = InetAddress.getByAddress(this.ip);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.inetAddress;
    }

    public static InternetAddressRR<? extends InetAddress> from(InetAddress inetAddress) {
        if (inetAddress instanceof Inet4Address) {
            return new A((Inet4Address)inetAddress);
        }
        return new AAAA((Inet6Address)inetAddress);
    }
}

