/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.minidns.record;

import github.scarsz.discordsrv.dependencies.minidns.record.Data;
import github.scarsz.discordsrv.dependencies.minidns.record.Record;
import github.scarsz.discordsrv.dependencies.minidns.util.Base64;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class OPENPGPKEY
extends Data {
    private final byte[] publicKeyPacket;
    private transient String publicKeyPacketBase64Cache;

    public static OPENPGPKEY parse(DataInputStream dis, int length) throws IOException {
        byte[] publicKeyPacket = new byte[length];
        dis.readFully(publicKeyPacket);
        return new OPENPGPKEY(publicKeyPacket);
    }

    OPENPGPKEY(byte[] publicKeyPacket) {
        this.publicKeyPacket = publicKeyPacket;
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.OPENPGPKEY;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.write(this.publicKeyPacket);
    }

    public String toString() {
        return this.getPublicKeyPacketBase64();
    }

    public String getPublicKeyPacketBase64() {
        if (this.publicKeyPacketBase64Cache == null) {
            this.publicKeyPacketBase64Cache = Base64.encodeToString(this.publicKeyPacket);
        }
        return this.publicKeyPacketBase64Cache;
    }

    public byte[] getPublicKeyPacket() {
        return (byte[])this.publicKeyPacket.clone();
    }
}

