/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.minidns.record;

import github.scarsz.discordsrv.dependencies.minidns.edns.EdnsOption;
import github.scarsz.discordsrv.dependencies.minidns.record.Data;
import github.scarsz.discordsrv.dependencies.minidns.record.Record;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OPT
extends Data {
    public final List<EdnsOption> variablePart;

    public OPT() {
        this(Collections.emptyList());
    }

    public OPT(List<EdnsOption> variablePart) {
        this.variablePart = Collections.unmodifiableList(variablePart);
    }

    public static OPT parse(DataInputStream dis, int payloadLength) throws IOException {
        List<EdnsOption> variablePart;
        if (payloadLength == 0) {
            variablePart = Collections.emptyList();
        } else {
            int payloadLeft = payloadLength;
            variablePart = new ArrayList<EdnsOption>(4);
            while (payloadLeft > 0) {
                int optionCode = dis.readUnsignedShort();
                int optionLength = dis.readUnsignedShort();
                byte[] optionData = new byte[optionLength];
                dis.read(optionData);
                EdnsOption ednsOption = EdnsOption.parse(optionCode, optionData);
                variablePart.add(ednsOption);
                assert ((payloadLeft -= 4 + optionLength) >= 0);
            }
        }
        return new OPT(variablePart);
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.OPT;
    }

    @Override
    protected void serialize(DataOutputStream dos) throws IOException {
        for (EdnsOption endsOption : this.variablePart) {
            endsOption.writeToDos(dos);
        }
    }
}

