/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.minidns.record;

import github.scarsz.discordsrv.dependencies.minidns.constants.DnssecConstants;
import github.scarsz.discordsrv.dependencies.minidns.dnsname.DnsName;
import github.scarsz.discordsrv.dependencies.minidns.record.Data;
import github.scarsz.discordsrv.dependencies.minidns.record.Record;
import github.scarsz.discordsrv.dependencies.minidns.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class RRSIG
extends Data {
    public final Record.TYPE typeCovered;
    public final DnssecConstants.SignatureAlgorithm algorithm;
    public final byte algorithmByte;
    public final byte labels;
    public final long originalTtl;
    public final Date signatureExpiration;
    public final Date signatureInception;
    public final int keyTag;
    public final DnsName signerName;
    private final byte[] signature;
    private transient String base64SignatureCache;

    public static RRSIG parse(DataInputStream dis, byte[] data, int length) throws IOException {
        Record.TYPE typeCovered = Record.TYPE.getType(dis.readUnsignedShort());
        byte algorithm = dis.readByte();
        byte labels = dis.readByte();
        long originalTtl = (long)dis.readInt() & 0xFFFFFFFFL;
        Date signatureExpiration = new Date(((long)dis.readInt() & 0xFFFFFFFFL) * 1000L);
        Date signatureInception = new Date(((long)dis.readInt() & 0xFFFFFFFFL) * 1000L);
        int keyTag = dis.readUnsignedShort();
        DnsName signerName = DnsName.parse(dis, data);
        int sigSize = length - signerName.size() - 18;
        byte[] signature = new byte[sigSize];
        if (dis.read(signature) != signature.length) {
            throw new IOException();
        }
        return new RRSIG(typeCovered, null, algorithm, labels, originalTtl, signatureExpiration, signatureInception, keyTag, signerName, signature);
    }

    private RRSIG(Record.TYPE typeCovered, DnssecConstants.SignatureAlgorithm algorithm, byte algorithmByte, byte labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, DnsName signerName, byte[] signature) {
        this.typeCovered = typeCovered;
        assert (algorithmByte == (algorithm != null ? algorithm.number : algorithmByte));
        this.algorithmByte = algorithmByte;
        this.algorithm = algorithm != null ? algorithm : DnssecConstants.SignatureAlgorithm.forByte(algorithmByte);
        this.labels = labels;
        this.originalTtl = originalTtl;
        this.signatureExpiration = signatureExpiration;
        this.signatureInception = signatureInception;
        this.keyTag = keyTag;
        this.signerName = signerName;
        this.signature = signature;
    }

    public RRSIG(Record.TYPE typeCovered, int algorithm, byte labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, DnsName signerName, byte[] signature) {
        this(typeCovered, null, (byte)algorithm, labels, originalTtl, signatureExpiration, signatureInception, keyTag, signerName, signature);
    }

    public RRSIG(Record.TYPE typeCovered, int algorithm, byte labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, String signerName, byte[] signature) {
        this(typeCovered, null, (byte)algorithm, labels, originalTtl, signatureExpiration, signatureInception, keyTag, DnsName.from(signerName), signature);
    }

    public RRSIG(Record.TYPE typeCovered, DnssecConstants.SignatureAlgorithm algorithm, byte labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, DnsName signerName, byte[] signature) {
        this(typeCovered, (int)algorithm.number, labels, originalTtl, signatureExpiration, signatureInception, keyTag, signerName, signature);
    }

    public RRSIG(Record.TYPE typeCovered, DnssecConstants.SignatureAlgorithm algorithm, byte labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, String signerName, byte[] signature) {
        this(typeCovered, (int)algorithm.number, labels, originalTtl, signatureExpiration, signatureInception, keyTag, DnsName.from(signerName), signature);
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public DataInputStream getSignatureAsDataInputStream() {
        return new DataInputStream(new ByteArrayInputStream(this.signature));
    }

    public int getSignatureLength() {
        return this.signature.length;
    }

    public String getSignatureBase64() {
        if (this.base64SignatureCache == null) {
            this.base64SignatureCache = Base64.encodeToString(this.signature);
        }
        return this.base64SignatureCache;
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.RRSIG;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        this.writePartialSignature(dos);
        dos.write(this.signature);
    }

    public void writePartialSignature(DataOutputStream dos) throws IOException {
        dos.writeShort(this.typeCovered.getValue());
        dos.writeByte(this.algorithmByte);
        dos.writeByte(this.labels);
        dos.writeInt((int)this.originalTtl);
        dos.writeInt((int)(this.signatureExpiration.getTime() / 1000L));
        dos.writeInt((int)(this.signatureInception.getTime() / 1000L));
        dos.writeShort(this.keyTag);
        this.signerName.writeToStream(dos);
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        StringBuilder sb = new StringBuilder().append((Object)this.typeCovered).append(' ').append((Object)this.algorithm).append(' ').append(this.labels).append(' ').append(this.originalTtl).append(' ').append(dateFormat.format(this.signatureExpiration)).append(' ').append(dateFormat.format(this.signatureInception)).append(' ').append(this.keyTag).append(' ').append(this.signerName).append(". ").append(this.getSignatureBase64());
        return sb.toString();
    }
}

