/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.minidns.record;

import github.scarsz.discordsrv.dependencies.minidns.dnsmessage.DnsMessage;
import github.scarsz.discordsrv.dependencies.minidns.dnsmessage.Question;
import github.scarsz.discordsrv.dependencies.minidns.dnsname.DnsName;
import github.scarsz.discordsrv.dependencies.minidns.record.A;
import github.scarsz.discordsrv.dependencies.minidns.record.AAAA;
import github.scarsz.discordsrv.dependencies.minidns.record.CNAME;
import github.scarsz.discordsrv.dependencies.minidns.record.DLV;
import github.scarsz.discordsrv.dependencies.minidns.record.DNAME;
import github.scarsz.discordsrv.dependencies.minidns.record.DNSKEY;
import github.scarsz.discordsrv.dependencies.minidns.record.DS;
import github.scarsz.discordsrv.dependencies.minidns.record.Data;
import github.scarsz.discordsrv.dependencies.minidns.record.MX;
import github.scarsz.discordsrv.dependencies.minidns.record.NS;
import github.scarsz.discordsrv.dependencies.minidns.record.NSEC;
import github.scarsz.discordsrv.dependencies.minidns.record.NSEC3;
import github.scarsz.discordsrv.dependencies.minidns.record.NSEC3PARAM;
import github.scarsz.discordsrv.dependencies.minidns.record.OPENPGPKEY;
import github.scarsz.discordsrv.dependencies.minidns.record.OPT;
import github.scarsz.discordsrv.dependencies.minidns.record.PTR;
import github.scarsz.discordsrv.dependencies.minidns.record.RRSIG;
import github.scarsz.discordsrv.dependencies.minidns.record.SOA;
import github.scarsz.discordsrv.dependencies.minidns.record.SRV;
import github.scarsz.discordsrv.dependencies.minidns.record.TLSA;
import github.scarsz.discordsrv.dependencies.minidns.record.TXT;
import github.scarsz.discordsrv.dependencies.minidns.record.UNKNOWN;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Record<D extends Data> {
    public final DnsName name;
    public final TYPE type;
    public final CLASS clazz;
    public final int clazzValue;
    public final long ttl;
    public final D payloadData;
    public final boolean unicastQuery;
    private transient byte[] bytes;
    private transient Integer hashCodeCache;

    public static Record<Data> parse(DataInputStream dis, byte[] data) throws IOException {
        Data payloadData;
        DnsName name = DnsName.parse(dis, data);
        int typeValue = dis.readUnsignedShort();
        TYPE type = TYPE.getType(typeValue);
        int clazzValue = dis.readUnsignedShort();
        CLASS clazz = CLASS.getClass(clazzValue & Short.MAX_VALUE);
        boolean unicastQuery = (clazzValue & 0x8000) > 0;
        long ttl = ((long)dis.readUnsignedShort() << 16) + (long)dis.readUnsignedShort();
        int payloadLength = dis.readUnsignedShort();
        switch (type) {
            case SOA: {
                payloadData = SOA.parse(dis, data);
                break;
            }
            case SRV: {
                payloadData = SRV.parse(dis, data);
                break;
            }
            case MX: {
                payloadData = MX.parse(dis, data);
                break;
            }
            case AAAA: {
                payloadData = AAAA.parse(dis);
                break;
            }
            case A: {
                payloadData = A.parse(dis);
                break;
            }
            case NS: {
                payloadData = NS.parse(dis, data);
                break;
            }
            case CNAME: {
                payloadData = CNAME.parse(dis, data);
                break;
            }
            case DNAME: {
                payloadData = DNAME.parse(dis, data);
                break;
            }
            case PTR: {
                payloadData = PTR.parse(dis, data);
                break;
            }
            case TXT: {
                payloadData = TXT.parse(dis, payloadLength);
                break;
            }
            case OPT: {
                payloadData = OPT.parse(dis, payloadLength);
                break;
            }
            case DNSKEY: {
                payloadData = DNSKEY.parse(dis, payloadLength);
                break;
            }
            case RRSIG: {
                payloadData = RRSIG.parse(dis, data, payloadLength);
                break;
            }
            case DS: {
                payloadData = DS.parse(dis, payloadLength);
                break;
            }
            case NSEC: {
                payloadData = NSEC.parse(dis, data, payloadLength);
                break;
            }
            case NSEC3: {
                payloadData = NSEC3.parse(dis, payloadLength);
                break;
            }
            case NSEC3PARAM: {
                payloadData = NSEC3PARAM.parse(dis);
                break;
            }
            case TLSA: {
                payloadData = TLSA.parse(dis, payloadLength);
                break;
            }
            case OPENPGPKEY: {
                payloadData = OPENPGPKEY.parse(dis, payloadLength);
                break;
            }
            case DLV: {
                payloadData = DLV.parse(dis, payloadLength);
                break;
            }
            default: {
                payloadData = UNKNOWN.parse(dis, payloadLength, type);
            }
        }
        return new Record<Data>(name, type, clazz, clazzValue, ttl, payloadData, unicastQuery);
    }

    public Record(DnsName name, TYPE type, CLASS clazz, long ttl, D payloadData, boolean unicastQuery) {
        this(name, type, clazz, clazz.getValue() + (unicastQuery ? 32768 : 0), ttl, payloadData, unicastQuery);
    }

    public Record(String name, TYPE type, CLASS clazz, long ttl, D payloadData, boolean unicastQuery) {
        this(DnsName.from(name), type, clazz, ttl, payloadData, unicastQuery);
    }

    public Record(String name, TYPE type, int clazzValue, long ttl, D payloadData) {
        this(DnsName.from(name), type, CLASS.NONE, clazzValue, ttl, payloadData, false);
    }

    public Record(DnsName name, TYPE type, int clazzValue, long ttl, D payloadData) {
        this(name, type, CLASS.NONE, clazzValue, ttl, payloadData, false);
    }

    private Record(DnsName name, TYPE type, CLASS clazz, int clazzValue, long ttl, D payloadData, boolean unicastQuery) {
        this.name = name;
        this.type = type;
        this.clazz = clazz;
        this.clazzValue = clazzValue;
        this.ttl = ttl;
        this.payloadData = payloadData;
        this.unicastQuery = unicastQuery;
    }

    public void toOutputStream(OutputStream outputStream) throws IOException {
        if (this.payloadData == null) {
            throw new IllegalStateException("Empty Record has no byte representation");
        }
        DataOutputStream dos = new DataOutputStream(outputStream);
        this.name.writeToStream(dos);
        dos.writeShort(this.type.getValue());
        dos.writeShort(this.clazzValue);
        dos.writeInt((int)this.ttl);
        dos.writeShort(((Data)this.payloadData).length());
        ((Data)this.payloadData).toOutputStream(dos);
    }

    public byte[] toByteArray() {
        if (this.bytes == null) {
            int totalSize = this.name.size() + 10 + ((Data)this.payloadData).length();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(totalSize);
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                this.toOutputStream(dos);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.bytes = baos.toByteArray();
        }
        return (byte[])this.bytes.clone();
    }

    public String toString() {
        return this.name.getRawAce() + ".\t" + this.ttl + '\t' + (Object)((Object)this.clazz) + '\t' + (Object)((Object)this.type) + '\t' + this.payloadData;
    }

    public boolean isAnswer(Question q) {
        return !(q.type != this.type && q.type != TYPE.ANY || q.clazz != this.clazz && q.clazz != CLASS.ANY || !q.name.equals(this.name));
    }

    public boolean isUnicastQuery() {
        return this.unicastQuery;
    }

    public D getPayload() {
        return this.payloadData;
    }

    public long getTtl() {
        return this.ttl;
    }

    public Question getQuestion() {
        switch (this.type) {
            case OPT: {
                return null;
            }
            case RRSIG: {
                RRSIG rrsig = (RRSIG)this.payloadData;
                return new Question(this.name, rrsig.typeCovered, this.clazz);
            }
        }
        return new Question(this.name, this.type, this.clazz);
    }

    public DnsMessage.Builder getQuestionMessage() {
        Question question = this.getQuestion();
        if (question == null) {
            return null;
        }
        return question.asMessageBuilder();
    }

    public int hashCode() {
        if (this.hashCodeCache == null) {
            int hashCode = 1;
            hashCode = 37 * hashCode + this.name.hashCode();
            hashCode = 37 * hashCode + this.type.hashCode();
            hashCode = 37 * hashCode + this.clazz.hashCode();
            hashCode = 37 * hashCode + ((Data)this.payloadData).hashCode();
            this.hashCodeCache = hashCode;
        }
        return this.hashCodeCache;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Record)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Record otherRecord = (Record)other;
        if (!this.name.equals(otherRecord.name)) {
            return false;
        }
        if (this.type != otherRecord.type) {
            return false;
        }
        if (this.clazz != otherRecord.clazz) {
            return false;
        }
        return ((Data)this.payloadData).equals(otherRecord.payloadData);
    }

    public <E extends Data> Record<E> ifPossibleAs(Class<E> dataClass) {
        if (this.type.dataClass == dataClass) {
            return this;
        }
        return null;
    }

    public <E extends Data> Record<E> as(Class<E> dataClass) {
        Record<E> eRecord = this.ifPossibleAs(dataClass);
        if (eRecord == null) {
            throw new IllegalArgumentException("The instance " + this + " can not be cast to a Record with" + dataClass);
        }
        return eRecord;
    }

    public static <E extends Data> void filter(Collection<Record<E>> result, Class<E> dataClass, Collection<Record<? extends Data>> input) {
        for (Record<? extends Data> record : input) {
            Record<E> filteredRecord = record.ifPossibleAs(dataClass);
            if (filteredRecord == null) continue;
            result.add(filteredRecord);
        }
    }

    public static <E extends Data> List<Record<E>> filter(Class<E> dataClass, Collection<Record<? extends Data>> input) {
        ArrayList<Record<E>> result = new ArrayList<Record<E>>(input.size());
        Record.filter(result, dataClass, input);
        return result;
    }

    public static enum CLASS {
        IN(1),
        CH(3),
        HS(4),
        NONE(254),
        ANY(255);

        private static final HashMap<Integer, CLASS> INVERSE_LUT;
        private final int value;

        private CLASS(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static CLASS getClass(int value) {
            return INVERSE_LUT.get(value);
        }

        static {
            INVERSE_LUT = new HashMap();
            for (CLASS c : CLASS.values()) {
                INVERSE_LUT.put(c.getValue(), c);
            }
        }
    }

    public static enum TYPE {
        UNKNOWN(-1),
        A(1, A.class),
        NS(2, NS.class),
        MD(3),
        MF(4),
        CNAME(5, CNAME.class),
        SOA(6, SOA.class),
        MB(7),
        MG(8),
        MR(9),
        NULL(10),
        WKS(11),
        PTR(12, PTR.class),
        HINFO(13),
        MINFO(14),
        MX(15, MX.class),
        TXT(16, TXT.class),
        RP(17),
        AFSDB(18),
        X25(19),
        ISDN(20),
        RT(21),
        NSAP(22),
        NSAP_PTR(23),
        SIG(24),
        KEY(25),
        PX(26),
        GPOS(27),
        AAAA(28, AAAA.class),
        LOC(29),
        NXT(30),
        EID(31),
        NIMLOC(32),
        SRV(33, SRV.class),
        ATMA(34),
        NAPTR(35),
        KX(36),
        CERT(37),
        A6(38),
        DNAME(39, DNAME.class),
        SINK(40),
        OPT(41, OPT.class),
        APL(42),
        DS(43, DS.class),
        SSHFP(44),
        IPSECKEY(45),
        RRSIG(46, RRSIG.class),
        NSEC(47, NSEC.class),
        DNSKEY(48, DNSKEY.class),
        DHCID(49),
        NSEC3(50, NSEC3.class),
        NSEC3PARAM(51, NSEC3PARAM.class),
        TLSA(52, TLSA.class),
        HIP(55),
        NINFO(56),
        RKEY(57),
        TALINK(58),
        CDS(59),
        CDNSKEY(60),
        OPENPGPKEY(61, OPENPGPKEY.class),
        CSYNC(62),
        SPF(99),
        UINFO(100),
        UID(101),
        GID(102),
        UNSPEC(103),
        NID(104),
        L32(105),
        L64(106),
        LP(107),
        EUI48(108),
        EUI64(109),
        TKEY(249),
        TSIG(250),
        IXFR(251),
        AXFR(252),
        MAILB(253),
        MAILA(254),
        ANY(255),
        URI(256),
        CAA(257),
        TA(32768),
        DLV(32769, DLV.class);

        private final int value;
        private final Class<?> dataClass;
        private static final Map<Integer, TYPE> INVERSE_LUT;
        private static final Map<Class<?>, TYPE> DATA_LUT;

        private TYPE(int value) {
            this(value, null);
        }

        private <D extends Data> TYPE(int value, Class<D> dataClass) {
            this.value = value;
            this.dataClass = dataClass;
        }

        public int getValue() {
            return this.value;
        }

        public <D extends Data> Class<D> getDataClass() {
            return this.dataClass;
        }

        public static TYPE getType(int value) {
            TYPE type = INVERSE_LUT.get(value);
            if (type == null) {
                return UNKNOWN;
            }
            return type;
        }

        public static <D extends Data> TYPE getType(Class<D> dataClass) {
            return DATA_LUT.get(dataClass);
        }

        static {
            INVERSE_LUT = new HashMap<Integer, TYPE>();
            DATA_LUT = new HashMap();
            for (TYPE t : TYPE.values()) {
                INVERSE_LUT.put(t.getValue(), t);
                if (t.dataClass == null) continue;
                DATA_LUT.put(t.dataClass, t);
            }
        }
    }
}

